/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.server;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.tasks.filters.RetryFilter;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.mockito.internal.util.reflection.Whitebox;

public class BackgroundTaskServerAssert
extends AbstractAssert<BackgroundTaskServerAssert, BackgroundTaskServer> {
    protected BackgroundTaskServerAssert(BackgroundTaskServer backgroundTaskServe) {
        super((Object)backgroundTaskServe, BackgroundTaskServerAssert.class);
    }

    public static BackgroundTaskServerAssert assertThat(BackgroundTaskServer backgroundTaskServer) {
        return new BackgroundTaskServerAssert(backgroundTaskServer);
    }

    public BackgroundTaskServerAssert hasRetryFilter(int defaultNbrOfRetries) {
        List filters = (List)Whitebox.getInternalState(((BackgroundTaskServer)this.actual).getTaskFilters(), "filters");
        TaskFilter retryFilter = filters.stream().filter(filter -> filter instanceof RetryFilter).reduce((first, second) -> second).orElseThrow(() -> new AssertionError((Object)"No retry filter found"));
        Assertions.assertThat((Integer)((Integer)Whitebox.getInternalState(retryFilter, "numberOfRetries"))).isEqualTo(defaultNbrOfRetries);
        return this;
    }

    public BackgroundTaskServerAssert hasTaskFilterOfType(Class<? extends TaskFilter> taskFilterClass) {
        List filters = (List)Whitebox.getInternalState(((BackgroundTaskServer)this.actual).getTaskFilters(), "filters");
        Assertions.assertThat((List)filters).anyMatch(taskFilter -> taskFilterClass.equals(taskFilter.getClass()));
        return this;
    }
}

