/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.storage;

import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.jmx.BackgroundTaskServerStatusMBean;
import cn.boboweike.carrot.server.jmx.TaskServerStats;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public class BackgroundTaskServerStatusTestBuilder {
    private final TaskServerStats taskServerStats = new TaskServerStats();
    private UUID id = UUID.randomUUID();
    private int workerPoolSize = 10;
    private int pollIntervalInSeconds = 15;
    private Duration deleteSucceededTasksAfter = BackgroundTaskServerConfiguration.DEFAULT_DELETE_SUCCEEDED_TASKS_DURATION;
    private Duration permanentlyDeleteDeletedTasksAfter = BackgroundTaskServerConfiguration.DEFAULT_PERMANENTLY_DELETE_TASKS_DURATION;
    private Instant firstHeartbeat;
    private Instant lastHeartbeat;
    private boolean running;

    private BackgroundTaskServerStatusTestBuilder() {
    }

    public static BackgroundTaskServerStatusTestBuilder aFastBackgroundTaskServerStatus() {
        return new BackgroundTaskServerStatusTestBuilder().withPollIntervalInSeconds(5);
    }

    public static BackgroundTaskServerStatusTestBuilder aDefaultBackgroundTaskServerStatus() {
        return new BackgroundTaskServerStatusTestBuilder();
    }

    public static BackgroundTaskServerStatusTestBuilder aBackgroundTaskServerStatusBasedOn(BackgroundTaskServerStatus status) {
        return new BackgroundTaskServerStatusTestBuilder().withId(status.getId()).withWorkerSize(status.getWorkerPoolSize()).withPollIntervalInSeconds(status.getPollIntervalInSeconds()).withRunning(status.isRunning()).withFirstHeartbeat(status.getFirstHeartbeat()).withLastHeartbeat(status.getLastHeartbeat());
    }

    public BackgroundTaskServerStatusTestBuilder withId(UUID id) {
        this.id = id;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withPollIntervalInSeconds(int pollIntervalInSeconds) {
        this.pollIntervalInSeconds = pollIntervalInSeconds;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withWorkerSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withFirstHeartbeat(Instant firstHeartbeat) {
        this.firstHeartbeat = firstHeartbeat;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withLastHeartbeat(Instant lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withRunning(boolean running) {
        this.running = running;
        return this;
    }

    public BackgroundTaskServerStatusTestBuilder withIsStarted() {
        this.firstHeartbeat = Instant.now().minusMillis(1L);
        this.lastHeartbeat = Instant.now();
        this.running = true;
        return this;
    }

    public BackgroundTaskServerStatus build() {
        return new BackgroundTaskServerStatus(this.id, this.workerPoolSize, this.pollIntervalInSeconds, this.deleteSucceededTasksAfter, this.permanentlyDeleteDeletedTasksAfter, this.firstHeartbeat, this.lastHeartbeat, this.running, this.taskServerStats.getSystemTotalMemory(), this.taskServerStats.getSystemFreeMemory(), this.taskServerStats.getSystemCpuLoad(), this.taskServerStats.getProcessMaxMemory(), this.taskServerStats.getProcessFreeMemory(), this.taskServerStats.getProcessAllocatedMemory(), this.taskServerStats.getProcessCpuLoad(), BackgroundTaskServerStatusMBean.NO_PARTITION);
    }
}

