/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.storage;

import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.StateName;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class PartitionedStorageProviderForTest
implements PartitionedStorageProvider {
    private final PartitionedStorageProvider storageProvider;

    public PartitionedStorageProviderForTest(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public String getName() {
        return this.storageProvider.getName();
    }

    public int getTotalNumOfPartitions() {
        return this.storageProvider.getTotalNumOfPartitions();
    }

    public boolean lockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.storageProvider.lockByPartition(partition, durationInSeconds, lockedBy);
    }

    public boolean extendLockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.storageProvider.extendLockByPartition(partition, durationInSeconds, lockedBy);
    }

    public boolean unlockByPartition(Integer partition) {
        return this.storageProvider.unlockByPartition(partition);
    }

    public void setTaskMapper(TaskMapper taskMapper) {
        this.storageProvider.setTaskMapper(taskMapper);
    }

    public void setPartitioner(Partitioner partitioner) {
        this.storageProvider.setPartitioner(partitioner);
    }

    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        this.storageProvider.setUpStorageProvider(databaseOptions);
    }

    public void addTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.addTaskStorageOnChangeListener(listener);
    }

    public void removeTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.removeTaskStorageOnChangeListener(listener);
    }

    public void announceBackgroundTaskServer(BackgroundTaskServerStatus serverStatus) {
        this.storageProvider.announceBackgroundTaskServer(serverStatus);
    }

    public boolean signalBackgroundTaskServerAlive(BackgroundTaskServerStatus serverStatus) {
        return this.storageProvider.signalBackgroundTaskServerAlive(serverStatus);
    }

    public void signalBackgroundTaskServerStopped(BackgroundTaskServerStatus serverStatus) {
        this.storageProvider.signalBackgroundTaskServerStopped(serverStatus);
    }

    public List<BackgroundTaskServerStatus> getBackgroundTaskServers() {
        return this.storageProvider.getBackgroundTaskServers();
    }

    public UUID getLongestRunningBackgroundTaskServerId() {
        return this.storageProvider.getLongestRunningBackgroundTaskServerId();
    }

    public int removeTimedOutBackgroundTaskServers(Instant heartbeatOlderThan) {
        return this.storageProvider.removeTimedOutBackgroundTaskServers(heartbeatOlderThan);
    }

    public void saveMetadata(CarrotMetadata metadata) {
        this.storageProvider.saveMetadata(metadata);
    }

    public List<CarrotMetadata> getMetadata(String name) {
        return this.storageProvider.getMetadata(name);
    }

    public CarrotMetadata getMetadata(String name, String owner) {
        return this.storageProvider.getMetadata(name, owner);
    }

    public void deleteMetadata(String name) {
        this.storageProvider.deleteMetadata(name);
    }

    public Task save(Task task) {
        return this.storageProvider.save(task);
    }

    public Task saveByPartition(Task task, Integer partition) {
        return this.storageProvider.saveByPartition(task, partition);
    }

    public int deletePermanentlyByPartition(UUID id, Integer partition) {
        return this.storageProvider.deletePermanentlyByPartition(id, partition);
    }

    public Task getTaskById(UUID id) {
        return this.storageProvider.getTaskById(id);
    }

    public List<Task> save(List<Task> tasks) {
        return this.storageProvider.save(tasks);
    }

    public List<Task> saveByPartition(List<Task> tasks, Integer partition) {
        return this.storageProvider.saveByPartition(tasks, partition);
    }

    public List<Task> getTasksByPartition(StateName state, Instant updatedBefore, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTasksByPartition(state, updatedBefore, pageRequest, partition);
    }

    public List<Task> getScheduledTasksByPartition(Instant scheduledBefore, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getScheduledTasksByPartition(scheduledBefore, pageRequest, partition);
    }

    public Long countTasks(StateName state) {
        return this.storageProvider.getTaskPageByPartition(state, PageRequest.ascOnUpdatedAt((int)0), Integer.valueOf(0)).getTotal();
    }

    public List<Task> getTasksByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTasksByPartition(state, pageRequest, partition);
    }

    public Page<Task> getTaskPageByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTaskPageByPartition(state, pageRequest, partition);
    }

    public int deleteTasksPermanentlyByPartition(StateName state, Instant updatedBefore, Integer partition) {
        return this.storageProvider.deleteTasksPermanentlyByPartition(state, updatedBefore, partition);
    }

    public Set<String> getDistinctTaskSignatures(StateName ... states) {
        return this.storageProvider.getDistinctTaskSignatures(states);
    }

    public boolean existsByPartition(TaskDetails taskDetails, Integer partition, StateName ... states) {
        return this.storageProvider.existsByPartition(taskDetails, partition, states);
    }

    public boolean recurringTaskExistsByPartition(String recurringTaskId, Integer partition, StateName ... states) {
        return this.storageProvider.recurringTaskExistsByPartition(recurringTaskId, partition, states);
    }

    public RecurringTask saveRecurringTask(RecurringTask recurringTask) {
        return this.storageProvider.saveRecurringTask(recurringTask);
    }

    public List<RecurringTask> getRecurringTasksByPartition(Integer partition) {
        return this.storageProvider.getRecurringTasksByPartition(partition);
    }

    public List<RecurringTask> getRecurringTasks() {
        return this.storageProvider.getRecurringTasks();
    }

    public long countRecurringTasksByPartition(Integer partition) {
        return this.storageProvider.countRecurringTasksByPartition(partition);
    }

    public int deleteRecurringTask(String id) {
        return this.storageProvider.deleteRecurringTask(id);
    }

    public TaskStatsData getTaskStatsData() {
        return this.storageProvider.getTaskStatsData();
    }

    public void publishTotalAmountOfSucceededTasks(int amount) {
        this.storageProvider.publishTotalAmountOfSucceededTasks(amount);
    }

    public Task getTaskById(TaskId taskId) {
        return this.storageProvider.getTaskById(taskId);
    }

    public void close() {
        this.storageProvider.close();
    }
}

