/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.storage;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.storage.BackgroundTaskServerStatusTestBuilder;
import cn.boboweike.carrot.fixtures.stubs.BackgroundTaskServerStub;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.fixtures.utils.SleepUtils;
import cn.boboweike.carrot.scheduling.Schedule;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.scheduling.cron.CronExpression;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.ServerTimedOutException;
import cn.boboweike.carrot.storage.StorageException;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.exceptions.Exceptions;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.data.TemporalOffset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.internal.util.reflection.Whitebox;

public abstract class PartitionedStorageProviderTest {
    protected PartitionedStorageProvider storageProvider;
    protected PartitionedStorageProvider throwingStorageProvider;
    protected BackgroundTaskServer backgroundTaskServer;
    protected TaskMapper taskMapper;
    public static int PARTITION_0 = 0;

    @BeforeEach
    public void cleanUpAndSetupBackgroundTaskServer() {
        this.cleanup();
        JacksonJsonMapper jsonMapper = new JacksonJsonMapper();
        Carrot.configure();
        this.storageProvider = this.getStorageProvider();
        this.backgroundTaskServer = new BackgroundTaskServerStub(this.storageProvider);
        this.taskMapper = new TaskMapper((JsonMapper)jsonMapper);
    }

    @AfterEach
    public void cleanupStorageProvider() {
        this.storageProvider.close();
    }

    protected abstract void cleanup();

    protected abstract PartitionedStorageProvider getStorageProvider();

    protected ThrowingStorageProvider makeThrowingStorageProvider(PartitionedStorageProvider storageProvider) {
        return new ThrowingStorageProvider(storageProvider, "TODO"){

            @Override
            protected void makeStorageProviderThrowException(PartitionedStorageProvider storageProvider) {
                throw new UnsupportedOperationException("Implement me!");
            }
        };
    }

    @Test
    void testAnnounceAndListBackgroundTaskServers() {
        BackgroundTaskServerStatus serverStatus1 = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus1);
        SleepUtils.sleep(100L);
        BackgroundTaskServerStatus serverStatus2 = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus2);
        SleepUtils.sleep(100L);
        this.storageProvider.signalBackgroundTaskServerAlive(BackgroundTaskServerStatusTestBuilder.aBackgroundTaskServerStatusBasedOn(serverStatus2).withLastHeartbeat(Instant.now()).build());
        SleepUtils.sleep(10L);
        this.storageProvider.signalBackgroundTaskServerAlive(BackgroundTaskServerStatusTestBuilder.aBackgroundTaskServerStatusBasedOn(serverStatus1).withLastHeartbeat(Instant.now()).build());
        List backgroundTaskServers = this.storageProvider.getBackgroundTaskServers();
        CarrotAssertions.assertThat((List)backgroundTaskServers).hasSize(2);
        CarrotAssertions.assertThat((Object)((BackgroundTaskServerStatus)backgroundTaskServers.get(0))).isEqualToComparingOnlyGivenFields((Object)serverStatus1, new String[]{"id", "workerPoolSize", "pollIntervalInSeconds", "running"});
        CarrotAssertions.assertThat((Object)((BackgroundTaskServerStatus)backgroundTaskServers.get(1))).isEqualToComparingOnlyGivenFields((Object)serverStatus2, new String[]{"id", "workerPoolSize", "pollIntervalInSeconds", "running"});
        CarrotAssertions.assertThat((Instant)((BackgroundTaskServerStatus)backgroundTaskServers.get(0)).getFirstHeartbeat()).isCloseTo((Temporal)serverStatus1.getFirstHeartbeat(), (TemporalOffset)CarrotAssertions.within((long)1000L, (TemporalUnit)ChronoUnit.MICROS));
        CarrotAssertions.assertThat((Instant)((BackgroundTaskServerStatus)backgroundTaskServers.get(0)).getLastHeartbeat()).isAfter(((BackgroundTaskServerStatus)backgroundTaskServers.get(0)).getFirstHeartbeat());
        CarrotAssertions.assertThat((Instant)((BackgroundTaskServerStatus)backgroundTaskServers.get(1)).getFirstHeartbeat()).isCloseTo((Temporal)serverStatus2.getFirstHeartbeat(), (TemporalOffset)CarrotAssertions.within((long)1000L, (TemporalUnit)ChronoUnit.MICROS));
        CarrotAssertions.assertThat((Instant)((BackgroundTaskServerStatus)backgroundTaskServers.get(1)).getLastHeartbeat()).isAfter(((BackgroundTaskServerStatus)backgroundTaskServers.get(1)).getFirstHeartbeat());
        CarrotAssertions.assertThat((List)backgroundTaskServers).extracting("id").containsExactly(new Object[]{serverStatus1.getId(), serverStatus2.getId()});
        CarrotAssertions.assertThat((Comparable)this.storageProvider.getLongestRunningBackgroundTaskServerId()).isEqualTo((Object)serverStatus1.getId());
        this.storageProvider.signalBackgroundTaskServerStopped(serverStatus1);
        CarrotAssertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1);
        CarrotAssertions.assertThat((Comparable)this.storageProvider.getLongestRunningBackgroundTaskServerId()).isEqualTo((Object)serverStatus2.getId());
    }

    @Test
    void testRemoveTimedOutBackgroundTaskServers() {
        BackgroundTaskServerStatus serverStatus1 = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus1);
        SleepUtils.sleep(50L);
        Instant deleteServersWithHeartbeatOlderThanThis = Instant.now();
        SleepUtils.sleep(50L);
        BackgroundTaskServerStatus serverStatus2 = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus2);
        int deletedServers = this.storageProvider.removeTimedOutBackgroundTaskServers(deleteServersWithHeartbeatOlderThanThis);
        CarrotAssertions.assertThat((int)deletedServers).isEqualTo(1);
        CarrotAssertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1);
        CarrotAssertions.assertThat((Comparable)((BackgroundTaskServerStatus)this.storageProvider.getBackgroundTaskServers().get(0)).getId()).isEqualTo((Object)serverStatus2.getId());
    }

    @Test
    void ifServerHasTimedOutAndSignalsItsAliveAnExceptionIsThrown() {
        BackgroundTaskServerStatus serverStatus = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus);
        SleepUtils.sleep(100L);
        Instant deleteServersWithHeartbeatOlderThanThis = Instant.now();
        this.storageProvider.removeTimedOutBackgroundTaskServers(deleteServersWithHeartbeatOlderThanThis);
        CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.signalBackgroundTaskServerAlive(serverStatus)).isInstanceOf(ServerTimedOutException.class);
    }

    @Test
    void testCRUDMetadataLifeCycle() {
        List metadataListBeforeCreate = this.storageProvider.getMetadata("shouldNotHappenException");
        CarrotAssertions.assertThat((List)metadataListBeforeCreate).isEmpty();
        CarrotMetadata metadata1 = new CarrotMetadata("shouldNotHappenException", UUID.randomUUID().toString(), Exceptions.getStackTraceAsString((Throwable)CarrotException.shouldNotHappenException((String)"bad!")));
        CarrotMetadata metadata2 = new CarrotMetadata("shouldNotHappenException", UUID.randomUUID().toString(), Exceptions.getStackTraceAsString((Throwable)CarrotException.shouldNotHappenException((String)"Really bad!")));
        this.storageProvider.saveMetadata(metadata1);
        this.storageProvider.saveMetadata(metadata2);
        List metadataListAfterCreate = this.storageProvider.getMetadata("shouldNotHappenException");
        CarrotAssertions.assertThat((List)metadataListAfterCreate).hasSize(2);
        CarrotAssertions.assertThat(this.storageProvider.getMetadata("shouldNotHappenException", metadata1.getOwner())).isEqualTo(metadata1);
        CarrotAssertions.assertThat(this.storageProvider.getMetadata("shouldNotHappenException", metadata2.getOwner())).isEqualTo(metadata2);
        CarrotMetadata metadata1Update = new CarrotMetadata("shouldNotHappenException", metadata1.getOwner(), "An Update");
        CarrotMetadata metadata2Update = new CarrotMetadata("shouldNotHappenException", metadata2.getOwner(), "An Update");
        this.storageProvider.saveMetadata(metadata1Update);
        this.storageProvider.saveMetadata(metadata2Update);
        List metadataListAfterUpdate = this.storageProvider.getMetadata("shouldNotHappenException");
        CarrotAssertions.assertThat((List)metadataListAfterUpdate).hasSize(2);
        this.storageProvider.deleteMetadata("shouldNotHappenException");
        List metadataListAfterDelete = this.storageProvider.getMetadata("shouldNotHappenException");
        CarrotAssertions.assertThat((List)metadataListAfterDelete).isEmpty();
    }

    @Test
    void testOnChangeListenerForSaveAndDeleteMetadata() {
        SimpleMetadataOnChangeListener onChangeListener = new SimpleMetadataOnChangeListener();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)onChangeListener);
        CarrotMetadata metadata = new CarrotMetadata(onChangeListener.listenForChangesOfMetadataName(), "some-owner", "some-value");
        this.storageProvider.saveMetadata(metadata);
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(1);
        CarrotAssertions.assertThat(onChangeListener.changes.get(0)).hasSize(1);
        this.storageProvider.deleteMetadata(metadata.getName());
        CarrotAssertions.assertThat(onChangeListener.changes).hasSizeGreaterThanOrEqualTo(2);
        CarrotAssertions.assertThat(onChangeListener.changes.get(onChangeListener.changes.size() - 1)).isEmpty();
    }

    @Test
    void testCRUDTaskLifeCycle() {
        Task scheduledTask = TaskTestBuilder.aScheduledTask().build();
        Task createdTask = this.storageProvider.save(scheduledTask);
        Task savedScheduledTask = this.storageProvider.getTaskById(createdTask.getId());
        savedScheduledTask.getMetadata().clear();
        CarrotAssertions.assertThat(savedScheduledTask).isEqualTo(createdTask);
        CarrotAssertions.assertThatTasks(this.storageProvider.getScheduledTasksByPartition(Instant.now(), PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{createdTask});
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(scheduledTask.getTaskDetails(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED})).isTrue();
        savedScheduledTask.enqueue();
        this.storageProvider.save(savedScheduledTask);
        Task savedEnqueuedTask = this.storageProvider.getTaskById(createdTask.getId());
        savedEnqueuedTask.getMetadata().clear();
        CarrotAssertions.assertThat(savedEnqueuedTask).isEqualTo(savedScheduledTask);
        CarrotAssertions.assertThatTasks(this.storageProvider.getScheduledTasksByPartition(Instant.now(), PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedEnqueuedTask});
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(scheduledTask.getTaskDetails(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED})).isFalse();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(scheduledTask.getTaskDetails(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED})).isTrue();
        savedEnqueuedTask.startProcessingOn(this.backgroundTaskServer);
        this.storageProvider.save(savedEnqueuedTask);
        Task savedProcessingTask = this.storageProvider.getTaskById(createdTask.getId());
        savedProcessingTask.getMetadata().clear();
        savedProcessingTask.getMetadata().clear();
        CarrotAssertions.assertThat(savedProcessingTask).isEqualTo(savedEnqueuedTask);
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedProcessingTask});
        savedProcessingTask.failed("A failure", (Exception)new RuntimeException());
        savedProcessingTask.scheduleAt(Instant.now(), "Task failed");
        this.storageProvider.save(savedProcessingTask);
        Task savedRescheduledTask = this.storageProvider.getTaskById(createdTask.getId());
        savedRescheduledTask.getMetadata().clear();
        CarrotAssertions.assertThat(savedRescheduledTask).isEqualTo(savedProcessingTask);
        CarrotAssertions.assertThatTasks(this.storageProvider.getScheduledTasksByPartition(Instant.now(), PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedRescheduledTask});
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        savedRescheduledTask.enqueue();
        this.storageProvider.save(savedRescheduledTask);
        Task savedEnqueuedTaskRetry = this.storageProvider.getTaskById(createdTask.getId());
        savedEnqueuedTaskRetry.getMetadata().clear();
        CarrotAssertions.assertThat(savedEnqueuedTaskRetry).isEqualTo(savedRescheduledTask);
        CarrotAssertions.assertThatTasks(this.storageProvider.getScheduledTasksByPartition(Instant.now(), PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedEnqueuedTaskRetry});
        savedEnqueuedTaskRetry.startProcessingOn(this.backgroundTaskServer);
        this.storageProvider.save(savedEnqueuedTaskRetry);
        Task savedProcessingTaskRetry = this.storageProvider.getTaskById(createdTask.getId());
        savedProcessingTaskRetry.getMetadata().clear();
        CarrotAssertions.assertThat(savedProcessingTaskRetry).isEqualTo(savedEnqueuedTaskRetry);
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedProcessingTaskRetry});
        savedProcessingTaskRetry.succeeded();
        this.storageProvider.save(savedProcessingTaskRetry);
        Task savedSucceededTask = this.storageProvider.getTaskById(createdTask.getId());
        savedSucceededTask.getMetadata().clear();
        CarrotAssertions.assertThat(savedSucceededTask).isEqualTo(savedProcessingTaskRetry);
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{savedSucceededTask});
        savedSucceededTask.delete("By test");
        this.storageProvider.save(savedSucceededTask);
        Task fetchedDeletedTask = this.storageProvider.getTaskById(createdTask.getId());
        fetchedDeletedTask.getMetadata().clear();
        CarrotAssertions.assertThat(fetchedDeletedTask).hasState(StateName.DELETED);
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.DELETED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).contains((Object[])new Task[]{fetchedDeletedTask});
        int permanentlyDeletedTasks = this.storageProvider.deletePermanentlyByPartition(createdTask.getId(), Integer.valueOf(PARTITION_0));
        CarrotAssertions.assertThat((int)permanentlyDeletedTasks).isEqualTo(1);
        CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.getTaskById(savedEnqueuedTask.getId())).isInstanceOf(TaskNotFoundException.class);
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.DELETED, PageRequest.ascOnUpdatedAt((int)1000), Integer.valueOf(PARTITION_0))).isEmpty();
    }

    @Test
    void testOptimisticLockingOnSaveTask() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Task createdTask = this.storageProvider.save(task);
        Task fetchedTask = this.storageProvider.getTaskById(createdTask.getId());
        Task task1 = this.taskMapper.deserializeTask(this.taskMapper.serializeTask(fetchedTask));
        Task task2 = this.taskMapper.deserializeTask(this.taskMapper.serializeTask(fetchedTask));
        task1.startProcessingOn(this.backgroundTaskServer);
        task2.startProcessingOn(this.backgroundTaskServer);
        this.storageProvider.save(task1);
        CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.save(task2)).isInstanceOf(ConcurrentTaskModificationException.class);
        CarrotAssertions.assertThat(task1).hasVersion(2);
        CarrotAssertions.assertThat(task2).hasVersion(1);
    }

    @Test
    void testSaveOfTaskWithSameId() {
        UUID id = UUID.randomUUID();
        Task task1 = TaskTestBuilder.anEnqueuedTask().withId(id).build();
        Task task2 = TaskTestBuilder.anEnqueuedTask().withId(id).build();
        this.storageProvider.save(task1);
        CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.save(task2)).isInstanceOf(ConcurrentTaskModificationException.class);
    }

    @Test
    void testExceptionOnSaveTask() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Task enqueuedTask = this.storageProvider.save(task);
        task.startProcessingOn(this.backgroundTaskServer);
        try (ThrowingStorageProvider ignored = this.makeThrowingStorageProvider(this.storageProvider);){
            CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.save(enqueuedTask)).isInstanceOf(StorageException.class);
        }
        task.updateProcessing();
        Assertions.assertThatCode(() -> this.storageProvider.save(enqueuedTask)).doesNotThrowAnyException();
    }

    @Test
    void testOptimisticLockingOnSaveTasks() {
        Task task = TaskTestBuilder.aTaskInProgress().build();
        Task createdTask1 = this.storageProvider.save(TaskTestBuilder.aCopyOf(task).withId().build());
        Task createdTask2 = this.storageProvider.save(TaskTestBuilder.aCopyOf(task).withId().build());
        Task createdTask3 = this.storageProvider.save(TaskTestBuilder.aCopyOf(task).withId().build());
        Task createdTask4 = this.storageProvider.save(TaskTestBuilder.aCopyOf(task).withId().build());
        this.storageProvider.save(TaskTestBuilder.aCopyOf(createdTask2).withSucceededState().build());
        this.storageProvider.save(TaskTestBuilder.aCopyOf(createdTask3).withDeletedState().build());
        createdTask1.updateProcessing();
        createdTask2.updateProcessing();
        createdTask3.updateProcessing();
        createdTask4.updateProcessing();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.save(Arrays.asList(createdTask1, createdTask2, createdTask3, createdTask4))).isInstanceOf(ConcurrentTaskModificationException.class)).has(CarrotAssertions.failedTask(createdTask2))).has(CarrotAssertions.failedTask(createdTask3));
        Assertions.assertThat(Arrays.asList(createdTask1, createdTask4)).allMatch(dbTask -> dbTask.getVersion() == 2);
        Assertions.assertThat(Arrays.asList(createdTask2, createdTask3)).allMatch(dbTask -> dbTask.getVersion() == 1);
    }

    @Test
    void testGetDistinctTaskSignatures() {
        TestService testService = new TestService();
        Task task1 = TaskTestBuilder.aScheduledTask().withTaskDetails((TaskLambda & Serializable)() -> testService.doWork(UUID.randomUUID())).build();
        Task task2 = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> testService.doWork(2)).build();
        Task task3 = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> testService.doWork(2)).build();
        Task task4 = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> testService.doWorkThatTakesLong(5)).build();
        Task task5 = TaskTestBuilder.aTaskInProgress().withTaskDetails((TaskLambda & Serializable)() -> testService.doWork(2, 5)).build();
        Task task6 = TaskTestBuilder.aSucceededTask().withTaskDetails((TaskLambda & Serializable)() -> testService.doWork(UUID.randomUUID())).build();
        this.storageProvider.save(Arrays.asList(task1, task2, task3, task4, task5, task6));
        Set distinctTaskSignaturesForScheduledTasks = this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.SCHEDULED});
        ((AbstractCollectionAssert)CarrotAssertions.assertThat((Collection)distinctTaskSignaturesForScheduledTasks).hasSize(1)).containsOnly((Object[])new String[]{"cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.util.UUID)"});
        Set distinctTaskSignaturesForEnqueuedTasks = this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.ENQUEUED});
        ((AbstractCollectionAssert)CarrotAssertions.assertThat((Collection)distinctTaskSignaturesForEnqueuedTasks).hasSize(2)).containsOnly((Object[])new String[]{"cn.boboweike.carrot.fixtures.stubs.TestService.doWorkThatTakesLong(java.lang.Integer)", "cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.lang.Integer)"});
        Set distinctTaskSignaturesForTasksInProgress = this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.PROCESSING});
        ((AbstractCollectionAssert)CarrotAssertions.assertThat((Collection)distinctTaskSignaturesForTasksInProgress).hasSize(1)).containsOnly((Object[])new String[]{"cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.lang.Integer,java.lang.Integer)"});
        Set distinctTaskSignaturesForSucceededTasks = this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.SUCCEEDED});
        ((AbstractCollectionAssert)CarrotAssertions.assertThat((Collection)distinctTaskSignaturesForSucceededTasks).hasSize(1)).containsOnly((Object[])new String[]{"cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.util.UUID)"});
        Set distinctTaskSignaturesForScheduledAndEnqueuedTasks = this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED});
        ((AbstractCollectionAssert)CarrotAssertions.assertThat((Collection)distinctTaskSignaturesForScheduledAndEnqueuedTasks).hasSize(3)).containsOnly((Object[])new String[]{"cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.util.UUID)", "cn.boboweike.carrot.fixtures.stubs.TestService.doWorkThatTakesLong(java.lang.Integer)", "cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.lang.Integer)"});
    }

    @Test
    void testExists() {
        TaskDetails taskDetails = TaskDetailsTestBuilder.defaultTaskDetails().build();
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withTaskDetails(taskDetails).build();
        Task scheduledTask = recurringTask.toScheduledTask();
        this.storageProvider.save(scheduledTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        Task enqueuedTask = recurringTask.toEnqueuedTask();
        this.storageProvider.save(enqueuedTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        scheduledTask.delete("For test");
        this.storageProvider.save(scheduledTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        CarrotAssertions.assertThat((boolean)this.storageProvider.existsByPartition(taskDetails, Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED, StateName.DELETED})).isTrue();
    }

    @Test
    void testRecurringTaskExists() {
        TaskDetails taskDetails = TaskDetailsTestBuilder.defaultTaskDetails().build();
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withTaskDetails(taskDetails).build();
        Task scheduledTask = recurringTask.toScheduledTask();
        this.storageProvider.save(scheduledTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        scheduledTask.enqueue();
        this.storageProvider.save(scheduledTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED})).isTrue();
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        scheduledTask.delete("For test");
        this.storageProvider.save(scheduledTask);
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.SCHEDULED, StateName.PROCESSING, StateName.SUCCEEDED})).isFalse();
        CarrotAssertions.assertThat((boolean)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), Integer.valueOf(PARTITION_0), new StateName[]{StateName.ENQUEUED, StateName.DELETED})).isTrue();
    }

    @Test
    void testSaveListUpdateListAndGetListOfTasks() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withName("1").withEnqueuedState(Instant.now().minusSeconds(30L)).build(), TaskTestBuilder.aTask().withName("2").withEnqueuedState(Instant.now().minusSeconds(20L)).build(), TaskTestBuilder.aTask().withName("3").withEnqueuedState(Instant.now().minusSeconds(10L)).build());
        List savedTasks = this.storageProvider.save(tasks);
        CarrotAssertions.assertThat(this.storageProvider).hasTasks(StateName.ENQUEUED, 3, PARTITION_0);
        CarrotAssertions.assertThat(this.storageProvider).hasTasks(StateName.PROCESSING, 0, PARTITION_0);
        savedTasks.forEach(task -> {
            task.startProcessingOn(this.backgroundTaskServer);
            SleepUtils.sleep(100L);
        });
        this.storageProvider.save(savedTasks);
        CarrotAssertions.assertThat(this.storageProvider).hasTasks(StateName.ENQUEUED, 0, PARTITION_0);
        CarrotAssertions.assertThat(this.storageProvider).hasTasks(StateName.PROCESSING, 3, PARTITION_0);
        List fetchedTasksAsc = this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksAsc).hasSize(3)).containsAll((Iterable)savedTasks);
        CarrotAssertions.assertThat((List)fetchedTasksAsc).extracting("taskName").containsExactly(new Object[]{"1", "2", "3"});
        List fetchedTasksDesc = this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.descOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksDesc).hasSize(3)).containsAll((Iterable)savedTasks);
        CarrotAssertions.assertThat((List)fetchedTasksDesc).extracting("taskName").containsExactly(new Object[]{"3", "2", "1"});
    }

    @Test
    void testExceptionOnSaveListOfTasks() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withName("1").withEnqueuedState(Instant.now().minusSeconds(30L)).build(), TaskTestBuilder.aTask().withName("2").withEnqueuedState(Instant.now().minusSeconds(20L)).build(), TaskTestBuilder.aTask().withName("3").withEnqueuedState(Instant.now().minusSeconds(10L)).build());
        List savedTasks = this.storageProvider.save(tasks);
        savedTasks.forEach(task -> task.startProcessingOn(this.backgroundTaskServer));
        try (ThrowingStorageProvider ignored = this.makeThrowingStorageProvider(this.storageProvider);){
            CarrotAssertions.assertThatThrownBy(() -> this.storageProvider.save(savedTasks)).isInstanceOf(StorageException.class);
        }
        savedTasks.forEach(Task::updateProcessing);
        this.storageProvider.save(savedTasks);
    }

    @Test
    void testTaskPageCanBeSorted() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(10L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(8L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(6L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(4L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(2L)).build());
        this.storageProvider.save(tasks);
        Page fetchedTasksAscOnPriorityAndAscOnCreated = this.storageProvider.getTaskPageByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)50), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksAscOnPriorityAndAscOnCreated.getItems()).hasSize(5)).containsExactly((Object[])new Task[]{tasks.get(0), tasks.get(1), tasks.get(2), tasks.get(3), tasks.get(4)});
        Page fetchedTasksDescOnUpdatedAt = this.storageProvider.getTaskPageByPartition(StateName.ENQUEUED, PageRequest.descOnUpdatedAt((int)50), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksDescOnUpdatedAt.getItems()).hasSize(5)).containsExactly((Object[])new Task[]{tasks.get(4), tasks.get(3), tasks.get(2), tasks.get(1), tasks.get(0)});
    }

    @Test
    void testTaskPageCanUseOffsetAndLimit() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(10L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(8L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(6L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(4L)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minusSeconds(2L)).build());
        this.storageProvider.save(tasks);
        Page fetchedTasksAsc = this.storageProvider.getTaskPageByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((long)2L, (int)2), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksAsc.getItems()).hasSize(2)).containsExactly((Object[])new Task[]{tasks.get(2), tasks.get(3)});
        Page fetchedTasksDesc = this.storageProvider.getTaskPageByPartition(StateName.ENQUEUED, PageRequest.descOnUpdatedAt((long)2L, (int)2), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(fetchedTasksDesc.getItems()).hasSize(2)).containsExactly((Object[])new Task[]{tasks.get(2), tasks.get(1)});
    }

    @Test
    void testGetListOfTasksUpdatedBefore() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(24L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(12L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(2L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now()).build());
        this.storageProvider.save(tasks);
        List resultTasks = this.storageProvider.getTasksByPartition(StateName.ENQUEUED, Instant.now().minus(3L, ChronoUnit.HOURS), PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0));
        ((ListAssert)CarrotAssertions.assertThatTasks(resultTasks).hasSize(2)).containsExactly((Object[])new Task[]{tasks.get(0), tasks.get(1)});
        ((ListAssert)CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, Instant.now().minus(1L, ChronoUnit.HOURS), PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0))).hasSize(3)).containsExactly((Object[])new Task[]{tasks.get(0), tasks.get(1), tasks.get(2)});
        ((ListAssert)CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.ENQUEUED, Instant.now().minus(1L, ChronoUnit.HOURS), PageRequest.descOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0))).hasSize(3)).containsExactly((Object[])new Task[]{tasks.get(2), tasks.get(1), tasks.get(0)});
        CarrotAssertions.assertThatTasks(this.storageProvider.getTasksByPartition(StateName.PROCESSING, Instant.now().minus(1L, ChronoUnit.HOURS), PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0))).isEmpty();
    }

    @Test
    void testDeleteTasks() {
        List<Task> tasks = Arrays.asList(TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(4L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(3L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now().minus(2L, ChronoUnit.HOURS)).build(), TaskTestBuilder.aTask().withEnqueuedState(Instant.now()).build());
        this.storageProvider.save(tasks);
        this.storageProvider.deleteTasksPermanentlyByPartition(StateName.ENQUEUED, Instant.now().minus(1L, ChronoUnit.HOURS), Integer.valueOf(PARTITION_0));
        List fetchedTasks = this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0));
        CarrotAssertions.assertThat((List)fetchedTasks).hasSize(1);
    }

    @Test
    void testScheduledTasks() {
        Task task1 = TaskTestBuilder.anEnqueuedTask().withState((TaskState)new ScheduledState(Instant.now())).build();
        Task task2 = TaskTestBuilder.anEnqueuedTask().withState((TaskState)new ScheduledState(Instant.now().plus(20L, ChronoUnit.HOURS))).build();
        List<Task> tasks = Arrays.asList(task1, task2);
        this.storageProvider.save(tasks);
        ((ListAssert)CarrotAssertions.assertThatTasks(this.storageProvider.getScheduledTasksByPartition(Instant.now().plus(5L, ChronoUnit.SECONDS), PageRequest.ascOnUpdatedAt((int)100), Integer.valueOf(PARTITION_0))).hasSize(1)).contains((Object[])new Task[]{task1});
    }

    @Test
    void testCRUDRecurringTask() {
        RecurringTask recurringTaskv1 = new RecurringTask("my-task", TaskDetailsTestBuilder.defaultTaskDetails().build(), (Schedule)CronExpression.create((String)Cron.daily()), ZoneId.systemDefault());
        this.storageProvider.saveRecurringTask(recurringTaskv1);
        CarrotAssertions.assertThat((List)this.storageProvider.getRecurringTasks()).hasSize(1);
        CarrotAssertions.assertThat((long)this.storageProvider.countRecurringTasksByPartition(Integer.valueOf(PARTITION_0))).isEqualTo(1L);
        RecurringTask recurringTaskv2 = new RecurringTask("my-task", TaskDetailsTestBuilder.defaultTaskDetails().build(), (Schedule)CronExpression.create((String)Cron.hourly()), ZoneId.systemDefault());
        this.storageProvider.saveRecurringTask(recurringTaskv2);
        CarrotAssertions.assertThat((List)this.storageProvider.getRecurringTasks()).hasSize(1);
        CarrotAssertions.assertThat((long)this.storageProvider.countRecurringTasksByPartition(Integer.valueOf(PARTITION_0))).isEqualTo(1L);
        CarrotAssertions.assertThat((String)((RecurringTask)this.storageProvider.getRecurringTasks().get(0)).getScheduleExpression()).isEqualTo(Cron.hourly());
        RecurringTask otherRecurringTask = new RecurringTask("my-other-task", TaskDetailsTestBuilder.defaultTaskDetails().build(), (Schedule)CronExpression.create((String)Cron.hourly()), ZoneId.systemDefault());
        this.storageProvider.saveRecurringTask(otherRecurringTask);
        CarrotAssertions.assertThat((List)this.storageProvider.getRecurringTasks()).hasSize(2);
        CarrotAssertions.assertThat((long)this.storageProvider.countRecurringTasksByPartition(Integer.valueOf(PARTITION_0))).isEqualTo(2L);
        this.storageProvider.deleteRecurringTask("my-task");
        CarrotAssertions.assertThat((List)this.storageProvider.getRecurringTasks()).hasSize(1);
    }

    @Test
    void testOnChangeListenerForSaveAndDeleteTask() {
        SimpleTaskStorageOnChangeListener onChangeListener = new SimpleTaskStorageOnChangeListener();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)onChangeListener);
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.storageProvider.save(task);
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(1);
        task.delete("For test");
        this.storageProvider.save(task);
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(2);
    }

    @Test
    void testOnChangeListenerForSaveTaskList() {
        SimpleTaskStorageOnChangeListener onChangeListener = new SimpleTaskStorageOnChangeListener();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)onChangeListener);
        List<Task> tasks = Arrays.asList(TaskTestBuilder.anEnqueuedTask().build(), TaskTestBuilder.anEnqueuedTask().build());
        this.storageProvider.save(tasks);
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(1);
        tasks.forEach(task -> task.startProcessingOn(this.backgroundTaskServer));
        this.storageProvider.save(tasks);
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(2);
    }

    @Test
    void testOnChangeListenerForDeleteTasksByState() {
        this.storageProvider.save(Arrays.asList(TaskTestBuilder.anEnqueuedTask().build(), TaskTestBuilder.anEnqueuedTask().build()));
        SimpleTaskStorageOnChangeListener onChangeListener = new SimpleTaskStorageOnChangeListener();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)onChangeListener);
        this.storageProvider.deleteTasksPermanentlyByPartition(StateName.ENQUEUED, Instant.now(), Integer.valueOf(PARTITION_0));
        CarrotAssertions.assertThat(onChangeListener.changes).hasSize(1);
    }

    @Test
    void testTaskStats() {
        this.storageProvider.announceBackgroundTaskServer(this.backgroundTaskServer.getServerStatus());
        Assertions.assertThatCode(() -> this.storageProvider.getTaskStatsData()).doesNotThrowAnyException();
        this.storageProvider.publishTotalAmountOfSucceededTasks(5);
        this.storageProvider.save(Arrays.asList(TaskTestBuilder.anEnqueuedTask().build(), TaskTestBuilder.anEnqueuedTask().build(), TaskTestBuilder.anEnqueuedTask().build(), TaskTestBuilder.aTaskInProgress().build(), TaskTestBuilder.aScheduledTask().build(), TaskTestBuilder.aFailedTask().build(), TaskTestBuilder.aFailedTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aDeletedTask().build()));
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("id1").build());
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("id2").build());
        TaskStats taskStats = this.storageProvider.getTaskStatsData().getOverallTaskStats();
        CarrotAssertions.assertThat((Long)taskStats.getScheduled()).isEqualTo(1L);
        CarrotAssertions.assertThat((Long)taskStats.getEnqueued()).isEqualTo(3L);
        CarrotAssertions.assertThat((Long)taskStats.getProcessing()).isEqualTo(1L);
        CarrotAssertions.assertThat((Long)taskStats.getFailed()).isEqualTo(2L);
        CarrotAssertions.assertThat((Long)taskStats.getSucceeded()).isEqualTo(1L);
        CarrotAssertions.assertThat((Long)taskStats.getAllTimeSucceeded()).isEqualTo(5L);
        CarrotAssertions.assertThat((Long)taskStats.getDeleted()).isEqualTo(1L);
        CarrotAssertions.assertThat((int)taskStats.getRecurringTasks()).isEqualTo(2);
        CarrotAssertions.assertThat((int)taskStats.getBackgroundTaskServers()).isEqualTo(1);
    }

    @Test
    @Disabled
    void testPerformance() {
        int amount = 1000000;
        IntStream.range(0, amount).peek(i -> {
            if (i % 10000 == 0) {
                System.out.println("Saving task " + i);
            }
        }).mapToObj(i -> TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("this is test " + i)).build()).collect(StreamUtils.batchCollector((int)1000, arg_0 -> ((PartitionedStorageProvider)this.storageProvider).save(arg_0)));
        AtomicInteger atomicInteger = new AtomicInteger();
        ((Stream)this.storageProvider.getTasksByPartition(StateName.ENQUEUED, PageRequest.ascOnUpdatedAt((int)10000), Integer.valueOf(PARTITION_0)).stream().parallel()).peek(task -> {
            task.startProcessingOn(this.backgroundTaskServer);
            this.storageProvider.save(task);
            if (atomicInteger.get() % 100 == 0) {
                System.out.println("Retrieved task " + atomicInteger.get());
            }
        }).forEach(task -> atomicInteger.incrementAndGet());
        CarrotAssertions.assertThat((AtomicInteger)atomicInteger).hasValue(10000);
    }

    public static abstract class ThrowingStorageProvider
    implements AutoCloseable {
        private final PartitionedStorageProvider storageProvider;
        private String fieldNameForReset;
        private Object originalState;

        public ThrowingStorageProvider(PartitionedStorageProvider storageProvider, String fieldNameForReset) {
            this.storageProvider = storageProvider;
            this.fieldNameForReset = fieldNameForReset;
            try {
                this.saveInternalStorageProviderState(storageProvider);
                this.makeStorageProviderThrowException(storageProvider);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception setting up ThrowingStorageProvider", e);
            }
        }

        @Override
        public void close() {
            this.resetStorageProviderUsingInternalState(this.storageProvider);
        }

        protected void saveInternalStorageProviderState(PartitionedStorageProvider storageProvider) {
            this.originalState = Whitebox.getInternalState(storageProvider, this.fieldNameForReset);
        }

        protected abstract void makeStorageProviderThrowException(PartitionedStorageProvider var1) throws Exception;

        protected void resetStorageProviderUsingInternalState(PartitionedStorageProvider storageProvider) {
            Whitebox.setInternalState(storageProvider, this.fieldNameForReset, this.originalState);
        }
    }

    private static class SimpleMetadataOnChangeListener
    implements MetadataChangeListener {
        private final List<List<CarrotMetadata>> changes = new ArrayList<List<CarrotMetadata>>();

        private SimpleMetadataOnChangeListener() {
        }

        public String listenForChangesOfMetadataName() {
            return "metadata-name";
        }

        public void onChange(List<CarrotMetadata> metadata) {
            this.changes.add(metadata);
        }
    }

    private static class SimpleTaskStorageOnChangeListener
    implements TaskStatsChangeListener {
        private final List<TaskStatsData> changes = new ArrayList<TaskStatsData>();

        private SimpleTaskStorageOnChangeListener() {
        }

        public void onChange(TaskStatsData TaskStatsData2) {
            this.changes.add(TaskStatsData2);
        }
    }
}

