/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.storage;

import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StubDataProvider {
    private final PartitionedStorageProvider storageProvider;

    private StubDataProvider(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public static StubDataProvider using(PartitionedStorageProvider storageProvider) {
        return new StubDataProvider(storageProvider);
    }

    public StubDataProvider addALotOfEnqueuedTasksThatTakeSomeTime() {
        for (int i = 0; i < 33; ++i) {
            List Tasks = IntStream.range(0, 1000).mapToObj(j -> TaskTestBuilder.anEnqueuedTaskThatTakesLong().build()).collect(Collectors.toList());
            this.storageProvider.save(Tasks);
        }
        this.storageProvider.save(TaskTestBuilder.aTask().withState((TaskState)new ScheduledState(Instant.now().plusSeconds(18000L))).build());
        this.storageProvider.save(TaskTestBuilder.aSucceededTask().build());
        this.storageProvider.save(TaskTestBuilder.aFailedTaskWithRetries().build());
        this.storageProvider.save(TaskTestBuilder.aFailedTaskThatEventuallySucceeded().build());
        return this;
    }

    public StubDataProvider addSomeRecurringTasks() {
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("import-sales-data").withName("Import all sales data at midnight").build());
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("generate-sales-reports").withName("Generate sales report at 3am").withCronExpression("0 3 * * *").build());
        return this;
    }
}

