/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.stubs;

import cn.boboweike.carrot.fixtures.stubs.TestServiceInterface;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.context.TaskDashboardProgressBar;
import cn.boboweike.carrot.tasks.filters.ApplyStateFilter;
import cn.boboweike.carrot.tasks.filters.ElectStateFilter;
import cn.boboweike.carrot.tasks.filters.TaskServerFilter;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.slf4j.MDC;

public class TestService
implements TestServiceInterface {
    private static int processedTasks = 0;

    public int getProcessedTasks() {
        return processedTasks;
    }

    public static void doStaticWork() {
        System.out.println("Doing some work from a static method... ");
    }

    public void doWork(Runnable runnable) throws Exception {
        runnable.run();
    }

    public void doWorkWithCommand(Command command) throws Exception {
        System.out.println("Doing some work... ");
        command.doWork();
    }

    public void doWorkWithFile(File file) throws Exception {
        System.out.println("Doing some work... " + file.getAbsolutePath());
    }

    public void doWorkWithPath(Path path) throws Exception {
        System.out.println("Doing some work... " + path.toFile().getAbsolutePath());
    }

    public void doWork(Work work) throws Exception {
        processedTasks += work.workCount;
        System.out.println("Doing some work... " + work.workCount + "; " + work.someString);
    }

    public void doWork(Double count) {
        System.out.println("Doing some work... " + processedTasks + count);
    }

    public void doWork(Integer count) {
        System.out.println("Doing some work... " + (processedTasks += count.intValue()) + "; " + Instant.now());
    }

    public void doWork(Long count) {
        processedTasks = (int)((long)processedTasks + count);
        System.out.println("Doing some work... " + processedTasks);
    }

    public void doWork(Integer count, TaskContext taskContext) throws InterruptedException {
        System.out.println("Doing some work... " + (processedTasks += count.intValue()) + "; taskId: " + taskContext.getTaskId());
        taskContext.saveMetadata("test", (Object)"test");
        Thread.sleep(6000L);
    }

    public void doWork(int countA, int countB) {
        System.out.println("Doing some work... " + (processedTasks += countA + countB));
    }

    @cn.boboweike.carrot.tasks.annotations.Task(name="Doing some hard work for user %1 (customerId: %X{customer.id})")
    public void doWorkWithAnnotation(Integer userId, String userName) {
        System.out.println("Doing some work... " + processedTasks);
    }

    public void doWork(int count, String aString, Instant instant) {
        System.out.println("Doing some work... " + (processedTasks += count) + " " + aString + " " + instant);
    }

    public void doWork(UUID uuid) {
        System.out.println("Doing some work... " + uuid);
    }

    public void doWorkWithUUID(UUID uuid) {
        System.out.println("Doing some work... " + uuid);
    }

    public void doWorkWithLong(Long value) {
        System.out.println("Doing some work... " + value);
    }

    public void doWork(UUID uuid, int count, Instant instant) {
        System.out.println("Doing some work... " + (processedTasks += count) + " " + uuid + " " + instant);
    }

    public void doWork(String aString, int count, Instant instant) {
        System.out.println("Doing some work... " + (processedTasks += count) + " " + aString + " " + instant);
    }

    public void doWork(LocalDateTime localDateTime) {
        System.out.println("Doing some work... " + processedTasks + " " + localDateTime.toString());
    }

    public void doWork(boolean bool, int i, long l, float f, double d) {
        System.out.println("Doing some work... " + bool + "; " + i + "; " + l + "; " + f + "; " + d);
    }

    public void doWork(byte b, short s, char c) {
        System.out.println("Doing some work... " + b + "; " + s + "; " + c);
    }

    public void doWorkWithEnum(Task task) {
        System.out.println("Doing some work: " + task.executeTask());
    }

    @Override
    @cn.boboweike.carrot.tasks.annotations.Task(name="Doing some work")
    public void doWork() {
        System.out.println("Doing some work... " + ++processedTasks);
    }

    @cn.boboweike.carrot.tasks.annotations.Task(taskFilters={TheSunIsAlwaysShiningElectStateFilter.class, TestFilter.class})
    public void doWorkWithCustomTaskFilters() {
        System.out.println("I will always succeed thanks to my SunIsAlwaysShiningElectStateFilter... ");
    }

    public String doWorkAndReturnResult(String someString) {
        return "Hello to you to " + someString;
    }

    @cn.boboweike.carrot.tasks.annotations.Task(name="Doing some work", retries=1)
    public void doWorkThatFails() {
        System.out.println("Whoopsie, an error will occur " + ++processedTasks);
        throw new RuntimeException("Whoopsie, an error occcured");
    }

    public void doWorkThatTakesLong(TaskContext taskContext) throws InterruptedException {
        TaskDashboardProgressBar progressBar = taskContext.progressBar(9);
        for (int i = 0; i < 10; ++i) {
            taskContext.logger().info("This is an info message test " + i);
            Thread.sleep(100L);
            taskContext.logger().warn("This is an warning message test " + i);
            Thread.sleep(100L);
            taskContext.logger().error("This is an error message test " + i);
            Thread.sleep(100L);
            taskContext.logger().info("This is an info message again " + i);
            Thread.sleep(100L);
            this.doWorkThatTakesLong(5 + ThreadLocalRandom.current().nextInt(0, 5));
            progressBar.setValue(i);
        }
    }

    public void doWorkThatTakesLong(int seconds) throws InterruptedException {
        try {
            TimeUnit.SECONDS.sleep(seconds);
            System.out.println("WORK IS DONE!!!!!!!!");
        }
        catch (InterruptedException e) {
            System.out.println("Thread has been interrupted");
            throw e;
        }
    }

    public void doWorkThatTakesLongInterruptThread(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
            System.out.println("WORK IS DONE!!!!!!!!");
        }
        catch (InterruptedException e) {
            System.out.println("Thread has been interrupted");
            Thread.currentThread().interrupt();
        }
    }

    public void doWorkThatTakesLongCatchInterruptException(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
            System.out.println("WORK IS DONE!!!!!!!!");
        }
        catch (InterruptedException e) {
            System.out.println("Thread has been interrupted - not rethrowing nor interrupting again");
        }
    }

    public void doWorkThatCanBeInterrupted(int seconds) throws InterruptedException {
        Instant start = Instant.now();
        long initialNbr = 0L;
        while (start.plusSeconds(seconds).isAfter(Instant.now())) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (Duration.between(start, Instant.now()).getSeconds() <= initialNbr) continue;
            System.out.println("WORK IS BEING DONE: " + Duration.between(start, Instant.now()).getSeconds());
            initialNbr = Duration.between(start, Instant.now()).getSeconds();
        }
    }

    public void doWorkThatTakesLong(long seconds) throws InterruptedException {
        this.doWorkThatTakesLong((int)seconds);
    }

    public void scheduleNewWork(int amount) {
        this.scheduleNewWork(amount, -1);
    }

    public void scheduleNewWork(int amount, int exceptionOnNbr) {
        int i = 0;
        while (i < amount) {
            if (i == exceptionOnNbr) {
                throw new IllegalStateException("An error has occurred processing item " + i);
            }
            int finalI = i++;
            BackgroundTask.enqueue((TaskLambda & Serializable)() -> this.doWork(finalI));
        }
    }

    public void scheduleNewWorkSlowly(int amount) {
        try {
            int i = 0;
            while (i < amount) {
                int finalI = i++;
                BackgroundTask.enqueue((TaskLambda & Serializable)() -> this.doWork(finalI));
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @cn.boboweike.carrot.tasks.annotations.Task(taskFilters={SkipProcessingElectStateFilter.class})
    public void tryToDoWorkButDontBecauseOfSomeBusinessRuleDefinedInTheOnStateElectionFilter() {
        System.out.println("This should not be executed");
    }

    public void doIllegalWork(IllegalWork illegalWork) {
        System.out.println("Doing some illegal work:" + illegalWork);
    }

    public void doWorkWithoutParameters() {
        this.doWork();
    }

    public void reset() {
        processedTasks = 0;
    }

    public UUID getAnUUID() {
        return UUID.randomUUID();
    }

    private void aPrivateMethod(String string, int someNumber) {
        System.out.println("Nothing to do");
    }

    public void carrotBatchWrappers(Long id, Long env, String param, String currentLogin) {
        System.out.println("Do work:" + id + "; " + env + "; " + param + "; " + currentLogin);
    }

    public void carrotBatchPrimitives(long id, long env, String param, String currentLogin) {
        System.out.println("Do work:" + id + "; " + env + "; " + param + "; " + currentLogin);
    }

    public static void doWorkInStaticMethod(UUID id) {
        System.out.println("Doing work in static method:" + id);
    }

    public void doWorkWithCollection(Set<Long> singleton) {
        System.out.println("Doing work with collections: " + singleton.size());
    }

    public void doWorkWithMDC(String key) {
        Assertions.assertThat((String)MDC.get((String)key)).isNotNull();
        String result = key + ": " + MDC.get((String)key) + "; ";
        System.out.println("Found following MDC keys: " + result);
    }

    public static enum Task {
        PROGRAMMING{

            @Override
            public String executeTask() {
                return "In the zone";
            }
        }
        ,
        CLEANING{

            @Override
            public String executeTask() {
                return "Cleaning the house - wishing I were in zone";
            }
        };


        public abstract String executeTask();
    }

    public static class GithubIssue335 {
        public void run(UUID id) {
            System.out.println("Running task for issue 335 " + id);
        }
    }

    public static class SimpleCommand
    implements Command<Void> {
        private String string;
        private int integer;

        protected SimpleCommand() {
        }

        public SimpleCommand(String string, int integer) {
            this.string = string;
            this.integer = integer;
        }

        @Override
        public Void doWork() {
            System.out.println("Simple Command " + this.string + " " + this.integer);
            return null;
        }
    }

    public static interface Command<T> {
        public T doWork();
    }

    public static class TestFilter
    implements TaskServerFilter,
    ApplyStateFilter {
        public void onStateApplied(cn.boboweike.carrot.tasks.Task task, TaskState oldState, TaskState newState) {
            task.getMetadata().put("onStateApplied", "");
        }

        public void onProcessing(cn.boboweike.carrot.tasks.Task task) {
            task.getMetadata().put("onProcessing", "");
        }

        public void onProcessed(cn.boboweike.carrot.tasks.Task task) {
            task.getMetadata().put("onProcessed", "");
        }
    }

    public static class SkipProcessingElectStateFilter
    implements ElectStateFilter {
        public void onStateElection(cn.boboweike.carrot.tasks.Task task, TaskState newState) {
            if (StateName.PROCESSING.equals((Object)newState.getName())) {
                task.delete("Should not run due to business rule.");
                task.scheduleAt(Instant.now(), "Rescheduled by business rule.");
            }
        }
    }

    public static class FailedToDeleteElectStateFilter
    implements ElectStateFilter {
        public void onStateElection(cn.boboweike.carrot.tasks.Task task, TaskState newState) {
            if (StateName.FAILED.equals((Object)newState.getName())) {
                task.delete("Because it failed");
            }
        }
    }

    public static class TheSunIsAlwaysShiningElectStateFilter
    implements ElectStateFilter {
        public void onStateElection(cn.boboweike.carrot.tasks.Task task, TaskState newState) {
            if (StateName.ENQUEUED.equals((Object)newState.getName())) {
                task.succeeded();
            }
        }
    }

    public static class IllegalWork {
        private long number;
        private IllegalWork illegalWork;

        public IllegalWork(long number) {
            this.number = number;
            this.illegalWork = this;
        }

        public IllegalWork getIllegalWork() {
            return this.illegalWork;
        }

        public long getNumber() {
            return this.number;
        }
    }

    public static class Work {
        private int workCount;
        private String someString;
        private UUID uuid;

        protected Work() {
        }

        public Work(int workCount, String someString, UUID uuid) {
            this.workCount = workCount;
            this.someString = someString;
            this.uuid = uuid;
        }

        public int getWorkCount() {
            return this.workCount;
        }

        public String getSomeString() {
            return this.someString;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Work work = (Work)o;
            if (this.workCount != work.workCount) {
                return false;
            }
            if (!Objects.equals(this.someString, work.someString)) {
                return false;
            }
            return Objects.equals(this.uuid, work.uuid);
        }

        public int hashCode() {
            int result = this.workCount;
            result = 31 * result + (this.someString != null ? this.someString.hashCode() : 0);
            result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
            return result;
        }

        public static Work from(int workCount, String someString, UUID uuid) {
            return new Work(workCount, someString, uuid);
        }
    }
}

