/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.stubs;

import cn.boboweike.carrot.tasks.annotations.Task;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.tasks.lambdas.TaskRequestHandler;

public class TestTaskRequest
implements TaskRequest {
    private final String input;
    private final boolean mustFail;
    private final long sleepAfterFinished;

    protected TestTaskRequest() {
        this(null);
    }

    public TestTaskRequest(String input) {
        this(input, false, 0L);
    }

    public TestTaskRequest(String input, long sleepAfterFinished) {
        this(input, false, sleepAfterFinished);
    }

    public TestTaskRequest(String input, boolean mustFail) {
        this(input, mustFail, 0L);
    }

    public TestTaskRequest(String input, boolean mustFail, long sleepAfterFinished) {
        this.input = input;
        this.mustFail = mustFail;
        this.sleepAfterFinished = sleepAfterFinished;
    }

    public Class<TestTaskRequestHandler> getTaskRequestHandler() {
        return TestTaskRequestHandler.class;
    }

    public String getInput() {
        return this.input;
    }

    public boolean mustFail() {
        return this.mustFail;
    }

    public static class TestTaskRequestHandler
    implements TaskRequestHandler<TestTaskRequest> {
        @Task(name="Some neat Task Display Name", retries=1)
        public void run(TestTaskRequest taskRequest) throws InterruptedException {
            if (taskRequest.mustFail()) {
                throw new IllegalArgumentException("it must fail");
            }
            System.out.println("Running simple task request in background: " + taskRequest.getInput());
            this.taskContext().saveMetadata("test", (Object)"test");
            if (taskRequest.sleepAfterFinished > 0L) {
                Thread.sleep(taskRequest.sleepAfterFinished * 1000L);
            }
        }
    }
}

