/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.stubs;

import cn.boboweike.carrot.tasks.annotations.Task;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.tasks.lambdas.TaskRequestHandler;

public class TestTaskRequestThatTakesLong
implements TaskRequest {
    private final String input;
    private final boolean mustFail;
    private final int nbrOfSeconds;

    protected TestTaskRequestThatTakesLong() {
        this(null);
    }

    public TestTaskRequestThatTakesLong(String input) {
        this(input, false, 0);
    }

    public TestTaskRequestThatTakesLong(String input, int nbrOfSeconds) {
        this(input, false, nbrOfSeconds);
    }

    public TestTaskRequestThatTakesLong(String input, boolean mustFail, int nbrOfSeconds) {
        this.input = input;
        this.mustFail = mustFail;
        this.nbrOfSeconds = nbrOfSeconds;
    }

    public Class<TestTaskRequestThatTakesLongHandler> getTaskRequestHandler() {
        return TestTaskRequestThatTakesLongHandler.class;
    }

    public String getInput() {
        return this.input;
    }

    public boolean mustFail() {
        return this.mustFail;
    }

    public static class TestTaskRequestThatTakesLongHandler
    implements TaskRequestHandler<TestTaskRequestThatTakesLong> {
        @Task(name="Some neat Task Display Name", retries=1)
        public void run(TestTaskRequestThatTakesLong taskRequest) throws InterruptedException {
            if (taskRequest.mustFail()) {
                throw new IllegalArgumentException("it must fail");
            }
            if (taskRequest.nbrOfSeconds > 0) {
                Thread.sleep(taskRequest.nbrOfSeconds * 1000);
            }
            System.out.println("Running simple task request in background: " + taskRequest.getInput());
            this.taskContext().saveMetadata("test", (Object)"test");
        }
    }
}

