/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.tasks;

import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.scheduling.Schedule;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.scheduling.cron.CronExpression;
import cn.boboweike.carrot.scheduling.interval.Interval;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.TaskDetailsAsmGenerator;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;

public class RecurringTaskTestBuilder {
    private String id;
    private String name;
    private TaskDetails taskDetails;
    private Schedule schedule;
    private ZoneId zoneId;
    private Instant createdAt = Instant.now();

    private RecurringTaskTestBuilder() {
    }

    public static RecurringTaskTestBuilder aRecurringTask() {
        return new RecurringTaskTestBuilder();
    }

    public static RecurringTaskTestBuilder aDefaultRecurringTask() {
        return RecurringTaskTestBuilder.aRecurringTask().withId("anId").withName("a recurring task").withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).withCronExpression(Cron.daily()).withZoneId(ZoneId.systemDefault());
    }

    public RecurringTaskTestBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RecurringTaskTestBuilder withoutId() {
        this.id = null;
        return this;
    }

    public RecurringTaskTestBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public RecurringTaskTestBuilder withTaskDetails(TaskLambda taskLambda) {
        this.taskDetails = new TaskDetailsAsmGenerator().toTaskDetails(taskLambda);
        return this;
    }

    public RecurringTaskTestBuilder withTaskDetails(IocTaskLambda taskLambda) {
        this.taskDetails = new TaskDetailsAsmGenerator().toTaskDetails(taskLambda);
        return this;
    }

    public RecurringTaskTestBuilder withTaskDetails(TaskDetailsTestBuilder taskDetailsBuilder) {
        this.withTaskDetails(taskDetailsBuilder.build());
        return this;
    }

    public RecurringTaskTestBuilder withTaskDetails(TaskDetails taskDetails) {
        this.taskDetails = taskDetails;
        return this;
    }

    public RecurringTaskTestBuilder withCronExpression(String cronExpression) {
        this.schedule = CronExpression.create((String)cronExpression);
        return this;
    }

    public RecurringTaskTestBuilder withZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public RecurringTaskTestBuilder withIntervalExpression(String intervalExpression) {
        return this.withIntervalExpression(intervalExpression, Instant.now());
    }

    public RecurringTaskTestBuilder withIntervalExpression(String intervalExpression, Instant createdAt) {
        this.schedule = new Interval(Duration.parse(intervalExpression));
        this.createdAt = createdAt;
        return this;
    }

    public RecurringTask build() {
        RecurringTask recurringTask = new RecurringTask(this.id, this.taskDetails, this.schedule, this.zoneId, this.createdAt);
        recurringTask.setTaskName(this.name);
        return recurringTask;
    }
}

