/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.tasks;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.condition.AnyOf;
import org.assertj.core.data.TemporalOffset;

public class TaskAssert
extends AbstractAssert<TaskAssert, Task> {
    private TaskAssert(Task task) {
        super((Object)task, TaskAssert.class);
    }

    public static TaskAssert assertThat(Task task) {
        return new TaskAssert(task);
    }

    public TaskAssert hasTaskName(String name) {
        Assertions.assertThat((String)((Task)this.actual).getTaskName()).isEqualTo(name);
        return this;
    }

    public TaskAssert hasUpdatedAtCloseTo(Instant instant, TemporalOffset<Temporal> temporalOffset) {
        Assertions.assertThat((Instant)((Task)this.actual).getUpdatedAt()).isCloseTo((Temporal)instant, temporalOffset);
        return this;
    }

    public TaskAssert hasState(StateName state) {
        Assertions.assertThat((Comparable)((Task)this.actual).getState()).isEqualTo((Object)state);
        return this;
    }

    public TaskAssert hasOneOfTheFollowingStates(StateName ... states) {
        Assertions.assertThat((Object)((Task)this.actual)).has(AnyOf.anyOf((Iterable)Arrays.stream(states).map(TaskStateCondition::new).collect(Collectors.toList())));
        return this;
    }

    public TaskAssert doesNotHaveState(StateName stateName) {
        Assertions.assertThat((Comparable)((Task)this.actual).getState()).isNotEqualTo((Object)stateName);
        return this;
    }

    public TaskAssert hasStates(StateName ... state) {
        List taskStates = ((Task)this.actual).getTaskStates().stream().map(TaskState::getName).collect(Collectors.toList());
        Assertions.assertThat(taskStates).containsExactly((Object[])state);
        return this;
    }

    public TaskAssert hasMetadata(String key, String value) {
        Assertions.assertThat((Map)((Task)this.actual).getMetadata()).containsEntry((Object)key, (Object)value);
        return this;
    }

    public TaskAssert hasMetadata(Condition condition) {
        Map metadata = ((Task)this.actual).getMetadata();
        Assertions.assertThat((Map)metadata).has(condition);
        return this;
    }

    public TaskAssert hasMetadataOnlyContainingTaskProgressAndLogging() {
        for (String key : ((Task)this.actual).getMetadata().keySet()) {
            if (!key.startsWith("carrotDashboardLog") && !key.startsWith("carrotDashboardProgressBar")) {
                throw new AssertionError((Object)("Task has metadata key '" + key + "' which is not allowed"));
            }
        }
        return this;
    }

    public TaskAssert hasNoMetadata() {
        Assertions.assertThat((Map)((Task)this.actual).getMetadata()).isEmpty();
        return this;
    }

    public TaskAssert hasVersion(int version) {
        Assertions.assertThat((int)((Task)this.actual).getVersion()).isEqualTo(version);
        return this;
    }

    public TaskAssert hasRecurringTaskId(String recurringTaskId) {
        ((OptionalAssert)Assertions.assertThat((Optional)((Task)this.actual).getRecurringTaskId()).isPresent()).contains((Object)recurringTaskId);
        return this;
    }

    public TaskAssert isEqualTo(Task otherTask) {
        Assertions.assertThat((Object)((Task)this.actual)).usingRecursiveComparison().usingOverriddenEquals().ignoringFields(new String[]{"locker"}).isEqualTo((Object)otherTask);
        return this;
    }

    private static class TaskStateCondition
    extends Condition<Task> {
        public TaskStateCondition(StateName stateName) {
            super(task -> task.hasState(stateName), "Task should have state %s", new Object[]{stateName});
        }
    }
}

