/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.tasks;

import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.context.TaskContext;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class TaskDetailsAssert
extends AbstractAssert<TaskDetailsAssert, TaskDetails> {
    private TaskDetailsAssert(TaskDetails taskDetails) {
        super((Object)taskDetails, TaskDetailsAssert.class);
    }

    public static TaskDetailsAssert assertThat(TaskDetails taskDetails) {
        return new TaskDetailsAssert(taskDetails);
    }

    public TaskDetailsAssert isCacheable() {
        Assertions.assertThat((Boolean)((TaskDetails)this.actual).getCacheable()).isTrue();
        return this;
    }

    public TaskDetailsAssert isCacheable(Function<TaskDetails, Boolean> condition) {
        Assertions.assertThat((Boolean)((TaskDetails)this.actual).getCacheable()).isEqualTo((Object)condition.apply((TaskDetails)this.actual));
        return this;
    }

    public TaskDetailsAssert isNotCacheable() {
        Assertions.assertThat((Boolean)((TaskDetails)this.actual).getCacheable()).isFalse();
        return this;
    }

    public TaskDetailsAssert hasClass(Class<?> clazz) {
        this.hasClassName(clazz.getName());
        return this;
    }

    public TaskDetailsAssert hasClassName(String className) {
        Assertions.assertThat((String)((TaskDetails)this.actual).getClassName()).isEqualTo(className);
        return this;
    }

    public TaskDetailsAssert hasStaticFieldName(String staticFieldName) {
        Assertions.assertThat((String)((TaskDetails)this.actual).getStaticFieldName()).isEqualTo(staticFieldName);
        return this;
    }

    public TaskDetailsAssert hasMethodName(String methodName) {
        Assertions.assertThat((String)((TaskDetails)this.actual).getMethodName()).isEqualTo(methodName);
        return this;
    }

    public TaskDetailsAssert hasArgs(Object ... args) {
        Object[] taskParameterValues = ((TaskDetails)this.actual).getTaskParameterValues();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == TaskContext.Null) {
                Assertions.assertThat((Class)((TaskDetails)this.actual).getTaskParameterTypes()[i]).isEqualTo(TaskContext.class);
                continue;
            }
            Assertions.assertThat((Object)taskParameterValues[i]).isEqualTo(args[i]);
        }
        return this;
    }

    public TaskDetailsAssert hasArg(Predicate<Object> predicate) {
        Object[] taskParameterValues = ((TaskDetails)this.actual).getTaskParameterValues();
        ((ListAssert)Assertions.assertThat(Stream.of(taskParameterValues)).describedAs("Arg did not match predicate...", new Object[0])).anyMatch(predicate);
        return this;
    }

    public TaskDetailsAssert hasNoArgs() {
        Assertions.assertThat((List)((TaskDetails)this.actual).getTaskParameters()).isEmpty();
        return this;
    }

    public TaskDetailsAssert hasTaskContextArg() {
        Assertions.assertThat((List)((TaskDetails)this.actual).getTaskParameters()).isNotEmpty();
        Assertions.assertThat(((TaskDetails)this.actual).getTaskParameters().stream().filter(taskParameter -> taskParameter.getClassName().equals(TaskContext.class.getName())).findAny()).isPresent();
        return this;
    }
}

