/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.tasks;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import java.util.ArrayList;

public class TaskDetailsTestBuilder {
    private boolean isCacheable;
    private String className;
    private String staticFieldName;
    private String methodName;
    private ArrayList<TaskParameter> taskParameters = new ArrayList();

    private TaskDetailsTestBuilder() {
    }

    public static TaskDetailsTestBuilder taskDetails() {
        return new TaskDetailsTestBuilder();
    }

    public static TaskDetailsTestBuilder defaultTaskDetails() {
        return TaskDetailsTestBuilder.taskDetails().withCacheable(true).withClassName(TestService.class).withMethodName("doWork").withTaskParameter(5);
    }

    public static TaskDetailsTestBuilder systemOutPrintLnTaskDetails(String message) {
        return TaskDetailsTestBuilder.taskDetails().withCacheable(true).withClassName(System.class).withStaticFieldName("out").withMethodName("println").withTaskParameter(message);
    }

    public static TaskDetailsTestBuilder classThatDoesNotExistTaskDetails() {
        return TaskDetailsTestBuilder.taskDetails().withClassName("i.dont.exist.Class").withMethodName("notImportant").withTaskParameter(5);
    }

    public static TaskDetailsTestBuilder methodThatDoesNotExistTaskDetails() {
        return TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWorkThatDoesNotExist").withTaskParameter(5);
    }

    public static TaskDetailsTestBuilder taskParameterThatDoesNotExistTaskDetails() {
        return TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").withTaskParameter(new TaskParameter("i.dont.exist.Class", null));
    }

    private TaskDetailsTestBuilder withCacheable(boolean isCacheable) {
        this.isCacheable = isCacheable;
        return this;
    }

    public TaskDetailsTestBuilder withClassName(Class clazz) {
        this.className = clazz.getName();
        return this;
    }

    public TaskDetailsTestBuilder withClassName(String className) {
        this.className = className;
        return this;
    }

    public TaskDetailsTestBuilder withStaticFieldName(String staticFieldName) {
        this.staticFieldName = staticFieldName;
        return this;
    }

    public TaskDetailsTestBuilder withMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public TaskDetailsTestBuilder withTaskParameter(Object object) {
        this.taskParameters.add(new TaskParameter(object));
        return this;
    }

    public TaskDetailsTestBuilder withTaskParameter(TaskParameter taskParameter) {
        this.taskParameters.add(taskParameter);
        return this;
    }

    public TaskDetailsTestBuilder withTaskParameters(ArrayList<TaskParameter> taskParameters) {
        this.taskParameters = taskParameters;
        return this;
    }

    public TaskDetails build() {
        TaskDetails taskDetails = new TaskDetails(this.className, this.staticFieldName, this.methodName, this.taskParameters);
        taskDetails.setCacheable(this.isCacheable);
        return taskDetails;
    }
}

