/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.tasks;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.details.CachingTaskDetailsGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsAsmGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.states.DeletedState;
import cn.boboweike.carrot.tasks.states.EnqueuedState;
import cn.boboweike.carrot.tasks.states.FailedState;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.SucceededState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.resilience.Lock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.awaitility.reflect.WhiteboxImpl;
import org.mockito.internal.util.reflection.Whitebox;

public class TaskTestBuilder {
    private UUID id;
    private Integer version;
    private String name;
    private TaskDetails taskDetails;
    private List<TaskState> states = new ArrayList<TaskState>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private Lock locker;

    private TaskTestBuilder() {
    }

    public static TaskTestBuilder aTask() {
        return new TaskTestBuilder().withId().withName("the task").withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("a test"));
    }

    public static TaskTestBuilder aCopyOf(Task task) {
        return new TaskTestBuilder().withId(task.getId()).withName(task.getTaskName()).withVersion(task.getVersion()).withLock((Lock)WhiteboxImpl.getInternalState((Object)task, (String)"locker")).withTaskDetails(task.getTaskDetails()).withStates(task.getTaskStates()).withMetadata(task.getMetadata());
    }

    private TaskTestBuilder withStates(List<TaskState> taskStates) {
        taskStates.forEach(this::withState);
        return this;
    }

    public static TaskTestBuilder anEnqueuedTask() {
        return TaskTestBuilder.aTask().withName("an enqueued task").withState((TaskState)new EnqueuedState());
    }

    public static TaskTestBuilder anEnqueuedTaskThatTakesLong() {
        return TaskTestBuilder.aTask().withName("an enqueued task that takes long").withState((TaskState)new EnqueuedState()).withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWorkThatTakesLong").withTaskParameter(TaskContext.Null));
    }

    public static TaskTestBuilder aTaskInProgress() {
        return TaskTestBuilder.anEnqueuedTask().withState((TaskState)new ProcessingState(UUID.randomUUID()));
    }

    public static TaskTestBuilder aScheduledTask() {
        return TaskTestBuilder.aTask().withName("a scheduled task").withState((TaskState)new ScheduledState(Instant.now().minusSeconds(1L)));
    }

    public static TaskTestBuilder aFailedTask() {
        return TaskTestBuilder.anEnqueuedTask().withName("a failed task").withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("a test")).withState((TaskState)new ProcessingState(UUID.randomUUID())).withState((TaskState)new FailedState("a message", (Exception)new IllegalStateException()));
    }

    public static TaskTestBuilder aSucceededTask() {
        return TaskTestBuilder.anEnqueuedTask().withName("a succeeded task").withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("a test")).withState((TaskState)new ProcessingState(UUID.randomUUID())).withState((TaskState)new SucceededState(Duration.of(230L, ChronoUnit.SECONDS), Duration.ofSeconds(10L, 7345L)));
    }

    public static TaskTestBuilder aDeletedTask() {
        return TaskTestBuilder.anEnqueuedTask().withName("a deleted task").withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("a test")).withState((TaskState)new DeletedState("no reason"));
    }

    public static TaskTestBuilder aFailedTaskThatEventuallySucceeded() {
        TaskTestBuilder taskTestBuilder = TaskTestBuilder.aTask().withName("failed task").withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).withState((TaskState)new ScheduledState(Instant.now().minusSeconds(39600L)));
        UUID serverId = UUID.randomUUID();
        for (int i = 0; i < 4; ++i) {
            taskTestBuilder.withState((TaskState)new EnqueuedState());
            taskTestBuilder.withState((TaskState)new ProcessingState(serverId));
            taskTestBuilder.withState((TaskState)new FailedState("An exception occurred", (Exception)new IllegalStateException()));
            if (i >= 3) continue;
            taskTestBuilder.withState((TaskState)new ScheduledState(Instant.now().minusSeconds((10 - i) * 60 * 60), "Retry attempt " + (i + 1) + " of 10"));
        }
        taskTestBuilder.withState((TaskState)new SucceededState(Duration.of(230L, ChronoUnit.SECONDS), Duration.of(10L, ChronoUnit.SECONDS)));
        return taskTestBuilder;
    }

    public static TaskTestBuilder aFailedTaskWithRetries() {
        TaskTestBuilder taskTestBuilder = TaskTestBuilder.aTask().withName("failed task").withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("a test")).withState((TaskState)new ScheduledState(Instant.now().minusSeconds(39600L)));
        UUID serverId = UUID.randomUUID();
        for (int i = 0; i < 11; ++i) {
            taskTestBuilder.withState((TaskState)new EnqueuedState());
            taskTestBuilder.withState((TaskState)new ProcessingState(serverId));
            taskTestBuilder.withState((TaskState)new FailedState("An exception occurred", (Exception)new IllegalStateException()));
            if (i >= 10) continue;
            taskTestBuilder.withState((TaskState)new ScheduledState(Instant.now().minusSeconds((10 - i) * 60 * 60), "Retry attempt " + (i + 1) + " of 10"));
        }
        return taskTestBuilder;
    }

    public TaskTestBuilder withoutId() {
        this.id = null;
        return this;
    }

    public TaskTestBuilder withId() {
        return this.withId(UUID.randomUUID());
    }

    public TaskTestBuilder withId(UUID uuid) {
        this.id = uuid;
        return this;
    }

    public TaskTestBuilder withVersion(int version) {
        this.version = version;
        return this;
    }

    public TaskTestBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public TaskTestBuilder withoutName() {
        this.name = null;
        return this;
    }

    public TaskTestBuilder withLock(Lock lock) {
        this.locker = lock;
        return this;
    }

    public TaskTestBuilder withTaskDetails(TaskDetails taskDetails) {
        this.taskDetails = taskDetails;
        return this;
    }

    public TaskTestBuilder withTaskDetails(TaskLambda taskLambda) {
        this.taskDetails = new CachingTaskDetailsGenerator((TaskDetailsGenerator)new TaskDetailsAsmGenerator()).toTaskDetails(taskLambda);
        return this;
    }

    public TaskTestBuilder withTaskDetails(IocTaskLambda taskLambda) {
        this.taskDetails = new CachingTaskDetailsGenerator((TaskDetailsGenerator)new TaskDetailsAsmGenerator()).toTaskDetails(taskLambda);
        return this;
    }

    public TaskTestBuilder withTaskDetails(TaskDetailsTestBuilder taskDetailsTestBuilder) {
        this.taskDetails = taskDetailsTestBuilder.build();
        return this;
    }

    public TaskTestBuilder withState(TaskState state) {
        this.states.add(state);
        return this;
    }

    public TaskTestBuilder withState(TaskState state, Instant createdAt) {
        Whitebox.setInternalState(state, "createdAt", createdAt);
        if (state instanceof ProcessingState) {
            Whitebox.setInternalState(state, "updatedAt", createdAt);
        }
        this.states.add(state);
        return this;
    }

    public TaskTestBuilder withEnqueuedState(Instant createdAt) {
        this.withState((TaskState)new EnqueuedState(), createdAt);
        return this;
    }

    public TaskTestBuilder withScheduledState() {
        return this.withState((TaskState)new ScheduledState(Instant.now().minusSeconds(10L)));
    }

    public TaskTestBuilder withProcessingState() {
        return this.withState((TaskState)new ProcessingState(UUID.randomUUID()));
    }

    public TaskTestBuilder withSucceededState() {
        return this.withState((TaskState)new SucceededState(Duration.ofMillis(10L), Duration.ofMillis(3L)));
    }

    public TaskTestBuilder withSucceededState(Instant createdAt) {
        return this.withState((TaskState)new SucceededState(Duration.ofMillis(10L), Duration.ofMillis(3L)), createdAt);
    }

    public TaskTestBuilder withFailedState() {
        return this.withState((TaskState)new FailedState("Exception", new Exception()));
    }

    public TaskTestBuilder withDeletedState() {
        return this.withState((TaskState)new DeletedState("no reason"));
    }

    public TaskTestBuilder withMetadata(String key, Object metadata) {
        this.metadata.put(key, metadata);
        return this;
    }

    public TaskTestBuilder withMetadata(Map<String, Object> metadata) {
        this.metadata = new HashMap<String, Object>(metadata);
        return this;
    }

    public Task build() {
        Task task = new Task(this.id, this.taskDetails, this.states.remove(0));
        if (this.version != null) {
            Whitebox.setInternalState(task, "version", this.version);
        }
        if (this.locker != null) {
            Whitebox.setInternalState(task, "locker", this.locker);
        }
        task.setTaskName(this.name);
        task.getMetadata().putAll(this.metadata);
        ArrayList taskHistory = (ArrayList)WhiteboxImpl.getInternalState((Object)task, (String)"taskHistory");
        taskHistory.addAll(this.states);
        return task;
    }
}

