/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.lock;

import cn.boboweike.carrot.lock.FuzzTester;
import cn.boboweike.carrot.lock.LockProvider;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractLockProviderIntegrationTest {
    protected final String LOCK_NAME1 = UUID.randomUUID().toString();
    public static final Duration LOCK_AT_LEAST_FOR = Duration.ofSeconds(2L);

    protected abstract LockProvider getLockProvider();

    protected abstract void assertUnlocked(String var1);

    protected abstract void assertLocked(String var1);

    @Test
    public void shouldCreateLock() {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
        Assertions.assertThat((boolean)lock).isTrue();
        this.assertLocked(this.LOCK_NAME1);
        lockProvider.unlock(this.LOCK_NAME1);
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldNotReturnTrueSecondLock() {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
        Assertions.assertThat((boolean)lock).isTrue();
        Assertions.assertThat((boolean)AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1)).isFalse();
        lockProvider.unlock(this.LOCK_NAME1);
    }

    @Test
    public void shouldCreateTwoIndependentLocks() {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock1 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
        Assertions.assertThat((boolean)lock1).isTrue();
        boolean lock2 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, "name2");
        Assertions.assertThat((boolean)lock2).isTrue();
        lockProvider.unlock(this.LOCK_NAME1);
        lockProvider.unlock("name2");
    }

    @Test
    public void shouldLockTwiceInARow() {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock1 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
        Assertions.assertThat((boolean)lock1).isTrue();
        lockProvider.unlock(this.LOCK_NAME1);
        boolean lock2 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
        Assertions.assertThat((boolean)lock2).isTrue();
        lockProvider.unlock(this.LOCK_NAME1);
    }

    @Test
    public void shouldTimeOut() throws InterruptedException {
        this.doTestTimeOut(Duration.ofMillis(50L));
    }

    protected void doTestTimeOut(Duration lockAtMostFor) throws InterruptedException {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock1 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1, lockAtMostFor);
        Assertions.assertThat((boolean)lock1).isTrue();
        Thread.sleep(lockAtMostFor.toMillis() * 2L);
        this.assertUnlocked(this.LOCK_NAME1);
        boolean lock2 = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1, lockAtMostFor);
        Assertions.assertThat((boolean)lock2).isTrue();
        lockProvider.unlock(this.LOCK_NAME1);
    }

    @Test
    public void shouldBeAbleToLockRightAfterUnlock() {
        LockProvider lockProvider = this.getLockProvider();
        for (int i = 0; i < 10; ++i) {
            boolean lock = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)lock).describedAs("Successfully locked", new Object[0])).isTrue();
            Assertions.assertThat((boolean)AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1)).isFalse();
            lockProvider.unlock(this.LOCK_NAME1);
        }
    }

    @Test
    public void fuzzTestShouldPass() throws ExecutionException, InterruptedException {
        new FuzzTester(this.getLockProvider()).doFuzzTest();
    }

    @Test
    public void shouldBeAbleToExtendLock() {
        LockProvider lockProvider = this.getLockProvider();
        this.beforeExtendHelper(lockProvider, this.LOCK_NAME1, LOCK_AT_LEAST_FOR);
        boolean extendedLock = AbstractLockProviderIntegrationTest.extendHelper(lockProvider, this.LOCK_NAME1, Duration.ofSeconds(10L));
        Assertions.assertThat((boolean)extendedLock).isTrue();
        this.sleepFor(LOCK_AT_LEAST_FOR);
        this.assertLocked(this.LOCK_NAME1);
        lockProvider.unlock(this.LOCK_NAME1);
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldNotBeAbleToExtendUnlockedLock() {
        LockProvider lockProvider = this.getLockProvider();
        this.beforeExtendHelper(lockProvider, this.LOCK_NAME1, LOCK_AT_LEAST_FOR);
        lockProvider.unlock(this.LOCK_NAME1);
        this.assertUnlocked(this.LOCK_NAME1);
        boolean lock = AbstractLockProviderIntegrationTest.extendHelper(lockProvider, this.LOCK_NAME1, Duration.ofSeconds(10L));
        Assertions.assertThat((boolean)lock).isFalse();
    }

    @Test
    public void shouldNotBeAbleToExtendExpiredLock() {
        LockProvider lockProvider = this.getLockProvider();
        boolean lock = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, this.LOCK_NAME1, Duration.ofMillis(1L));
        this.sleepFor(Duration.ofMillis(1L));
        Assertions.assertThat((boolean)lock).isTrue();
        boolean extendedLock = AbstractLockProviderIntegrationTest.extendHelper(lockProvider, this.LOCK_NAME1, Duration.ofSeconds(10L));
        Assertions.assertThat((boolean)extendedLock).isFalse();
        this.assertUnlocked(this.LOCK_NAME1);
    }

    protected void sleepFor(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static boolean lockHelper(LockProvider lockProvider, String name) {
        return AbstractLockProviderIntegrationTest.lockHelper(lockProvider, name, Duration.of(5L, ChronoUnit.MINUTES));
    }

    protected static boolean lockHelper(LockProvider lockProvider, String name, Duration duration) {
        return lockProvider.lock(name, (int)duration.toSeconds(), name);
    }

    protected static boolean extendHelper(LockProvider lockProvider, String name, Duration duration) {
        return lockProvider.extend(name, (int)duration.toSeconds(), name);
    }

    protected void beforeExtendHelper(LockProvider lockProvider, String name, Duration duration) {
        boolean lock = AbstractLockProviderIntegrationTest.lockHelper(lockProvider, name, duration);
        Assertions.assertThat((boolean)lock).isTrue();
        this.assertLocked(name);
    }
}

