/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.lock;

import cn.boboweike.carrot.lock.AbstractLockProviderIntegrationTest;
import cn.boboweike.carrot.lock.LockProvider;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzTester {
    private static final int THREADS = 8;
    public static final int SHORT_ITERATION = 10;
    private final LockProvider lockProvider;
    private final Duration sleepFor;
    private final Duration lockAtMostFor;
    private final int iterations;
    private final Logger LOGGER = LoggerFactory.getLogger(FuzzTester.class);

    public FuzzTester(LockProvider lockProvider) {
        this(lockProvider, Duration.ofMillis(1L), Duration.of(5L, ChronoUnit.MINUTES), 100);
    }

    public FuzzTester(LockProvider lockProvider, Duration sleepFor, Duration lockAtMostFor, int iterations) {
        this.lockProvider = lockProvider;
        this.sleepFor = sleepFor;
        this.lockAtMostFor = lockAtMostFor;
        this.iterations = iterations;
    }

    public void doFuzzTest() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(8);
        int[] iters = IntStream.range(0, 8).map(i -> this.iterations).toArray();
        iters[0] = 10;
        Task task1 = new Task("lock1", this.lockAtMostFor);
        Task task2 = new Task("lock2", this.lockAtMostFor);
        List tasks = IntStream.range(0, 8).mapToObj(i -> () -> this.task(iters[i], i % 2 == 0 ? task1 : task2)).collect(Collectors.toList());
        this.waitFotIt(executor.invokeAll(tasks));
    }

    public void waitFotIt(List<Future<Void>> futures) throws ExecutionException, InterruptedException {
        for (Future<Void> f : futures) {
            f.get();
        }
    }

    protected Void task(int iterations, Task task) {
        try {
            int i = 0;
            while (i < iterations) {
                boolean lock = AbstractLockProviderIntegrationTest.lockHelper(this.lockProvider, task.getLockName(), task.getLockAtMostFor());
                if (!lock) continue;
                int n = task.getCounter();
                if (this.shouldLog()) {
                    this.LOGGER.debug("action=getLock value={} i={}", (Object)n, (Object)i);
                }
                this.sleep();
                if (this.shouldLog()) {
                    this.LOGGER.debug("action=setCounter value={} i={}", (Object)(n + 1), (Object)i);
                }
                task.setCounter(n + 1);
                this.lockProvider.unlock(task.getLockName());
                ++i;
            }
            this.LOGGER.debug("action=finished");
            return null;
        }
        catch (RuntimeException e) {
            this.LOGGER.error("Unexpected exception", (Throwable)e);
            throw e;
        }
    }

    protected boolean shouldLog() {
        return false;
    }

    protected void sleepFor(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sleep() {
        this.sleepFor(this.sleepFor);
    }

    protected static class Task {
        private final String lockName;
        private int counter = 0;
        private final Duration lockAtMostFor;

        Task(String lockName, Duration lockAtMostFor) {
            this.lockName = lockName;
            this.lockAtMostFor = lockAtMostFor;
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        public String getLockName() {
            return this.lockName;
        }

        public Duration getLockAtMostFor() {
            return this.lockAtMostFor;
        }
    }
}

