/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.lock.nosql;

import cn.boboweike.carrot.lock.AbstractLockProviderIntegrationTest;
import cn.boboweike.carrot.lock.LockProvider;
import cn.boboweike.carrot.lock.nosql.MongoLockProvider;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class MongoLockProviderIntegrationTest
extends AbstractLockProviderIntegrationTest {
    @Container
    private static final GenericContainer mongoContainer = new GenericContainer("mongo:latest").withExposedPorts(new Integer[]{27017});
    private static final String DEFAULT_SHEDLOCK_COLLECTION_NAME = StorageProviderUtils.elementPrefixer(null, (String)"shed_lock");
    private static MongoClient mongoClient;
    private static MongoDatabase nuTaskDb;

    @BeforeEach
    public void setUp() {
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()});
        mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(List.of(new ServerAddress(mongoContainer.getContainerIpAddress(), mongoContainer.getMappedPort(27017).intValue())))).codecRegistry(codecRegistry).build());
        nuTaskDb = mongoClient.getDatabase("carrot");
    }

    @AfterEach
    public void tearDown() throws Exception {
        mongoClient.close();
    }

    @BeforeEach
    public void cleanDb() {
        nuTaskDb.drop();
    }

    @Override
    protected LockProvider getLockProvider() {
        return new MongoLockProvider(this.getLockCollection());
    }

    @Override
    protected void assertUnlocked(String lockName) {
        Document lockDocument = this.getLockDocument(lockName);
        Assertions.assertThat((Date)((Date)lockDocument.get((Object)"lockUntil"))).isBeforeOrEqualTo(this.now());
        Assertions.assertThat((Date)((Date)lockDocument.get((Object)"lockedAt"))).isBeforeOrEqualTo(this.now());
        Assertions.assertThat((String)((String)lockDocument.get((Object)"lockedBy"))).isNotEmpty();
    }

    @Override
    protected void assertLocked(String lockName) {
        Document lockDocument = this.getLockDocument(lockName);
        Assertions.assertThat((Date)((Date)lockDocument.get((Object)"lockUntil"))).isAfter(this.now());
        Assertions.assertThat((Date)((Date)lockDocument.get((Object)"lockedAt"))).isBeforeOrEqualTo(this.now());
        Assertions.assertThat((String)((String)lockDocument.get((Object)"lockedBy"))).isNotEmpty();
    }

    private Date now() {
        return new Date();
    }

    private MongoCollection<Document> getLockCollection() {
        return nuTaskDb.getCollection(DEFAULT_SHEDLOCK_COLLECTION_NAME);
    }

    private Document getLockDocument(String lockName) {
        return (Document)this.getLockCollection().find(Filters.eq((String)"_id", (Object)lockName)).first();
    }
}

