/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.storage.PartitionedStorageProviderForTest;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.stubs.TestServiceForIoC;
import cn.boboweike.carrot.fixtures.stubs.TestServiceInterface;
import cn.boboweike.carrot.fixtures.tasks.stubs.SimpleTaskActivator;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambdaFromStream;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.states.StateName;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class BackgroundTaskByIoCTaskLambdaTest {
    private PartitionedStorageProviderForTest storageProvider;
    private BackgroundTaskServer backgroundTaskServer;
    private TestServiceForIoC testServiceForIoC;
    private TestServiceInterface testServiceInterface;
    private static final String every5Seconds = "*/5 * * * * *";

    @BeforeEach
    public void setUpTests() {
        this.storageProvider = new PartitionedStorageProviderForTest((PartitionedStorageProvider)new InMemoryPartitionedStorageProvider());
        this.testServiceForIoC = new TestServiceForIoC("a constructor arg");
        this.testServiceInterface = this.testServiceForIoC;
        SimpleTaskActivator taskActivator = new SimpleTaskActivator(this.testServiceForIoC, new TestService());
        Carrot.configure().useTaskActivator((TaskActivator)taskActivator).useStorageProvider((PartitionedStorageProvider)this.storageProvider).useBackgroundTaskServer(BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration().andPollIntervalInSeconds(5)).initialize();
        this.backgroundTaskServer = Carrot.getBackgroundTaskServer();
    }

    @AfterEach
    public void cleanUp() {
        MDC.clear();
        this.backgroundTaskServer.stop();
        this.storageProvider.close();
    }

    @Test
    void testEnqueue() {
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithMethodReference() {
        TaskId taskId = BackgroundTask.enqueue(TestService::doWork);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueUsingServiceInstance() {
        TaskId taskId = BackgroundTask.enqueue((TaskLambda & Serializable)() -> this.testServiceForIoC.doWork());
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueUsingServiceInterfaceInstance() {
        TaskId taskId = BackgroundTask.enqueue((TaskLambda & Serializable)() -> this.testServiceInterface.doWork());
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithCustomObject() {
        TestService.Work work = new TestService.Work(2, "some string", UUID.randomUUID());
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWork(work));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithPath() {
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWorkWithPath(Path.of("/tmp/carrot/example.log", new String[0])));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithTaskContextAndMetadata() {
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWork((Integer)5, TaskContext.Null));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.PROCESSING);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> !this.storageProvider.getTaskById(taskId).getMetadata().isEmpty());
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasMetadata("test", "test");
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED).hasMetadataOnlyContainingTaskProgressAndLogging();
    }

    @Test
    void testEnqueueStreamWithMultipleParameters() {
        Stream<UUID> workStream = this.getWorkStream();
        AtomicInteger atomicInteger = new AtomicInteger();
        BackgroundTask.enqueue(workStream, (IocTaskLambdaFromStream & Serializable)(x, uuid) -> x.doWork(uuid.toString(), atomicInteger.incrementAndGet(), Instant.now()));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((Long)this.storageProvider.countTasks(StateName.SUCCEEDED)).isEqualTo(5L));
    }

    @Test
    void testEnqueueStreamWithWrappingObjectAsParameter() {
        AtomicInteger atomicInteger = new AtomicInteger();
        Stream<TestService.Work> workStream = this.getWorkStream().map(uuid -> new TestService.Work(atomicInteger.incrementAndGet(), "some string " + uuid, (UUID)uuid));
        BackgroundTask.enqueue(workStream, (IocTaskLambdaFromStream & Serializable)(x, work) -> x.doWork((TestService.Work)work));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((Long)this.storageProvider.countTasks(StateName.SUCCEEDED)).isEqualTo(5L));
    }

    @Test
    void testEnqueueStreamWithParameterFromWrappingObject() {
        AtomicInteger atomicInteger = new AtomicInteger();
        Stream<TestService.Work> workStream = this.getWorkStream().map(uuid -> new TestService.Work(atomicInteger.incrementAndGet(), "some string " + uuid, (UUID)uuid));
        BackgroundTask.enqueue(workStream, (IocTaskLambdaFromStream & Serializable)(x, work) -> x.doWork(work.getUuid()));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((Long)this.storageProvider.countTasks(StateName.SUCCEEDED)).isEqualTo(5L));
    }

    @Test
    void testFailedTaskAddsFailedStateAndScheduledThanksToDefaultRetryFilter() {
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWorkThatFails());
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED));
    }

    @Test
    void testScheduleWithZonedDateTime() {
        TaskId taskId = BackgroundTask.schedule((ZonedDateTime)ZonedDateTime.now().plusSeconds(7L), (IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithOffsetDateTime() {
        TaskId taskId = BackgroundTask.schedule((OffsetDateTime)OffsetDateTime.now().plusSeconds(7L), (IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithLocalDateTime() {
        TaskId taskId = BackgroundTask.schedule((LocalDateTime)LocalDateTime.now().plusSeconds(7L), (IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithInstant() {
        TaskId taskId = BackgroundTask.schedule((Instant)Instant.now().plusSeconds(7L), (IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleUsingDateTimeInTheFutureIsNotEnqueued() {
        TaskId taskId = BackgroundTask.schedule((Instant)Instant.now().plus(100L, ChronoUnit.DAYS), (IocTaskLambda & Serializable)x -> x.doWork());
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED);
    }

    @Test
    void testScheduleThatSchedulesOtherTasks() {
        TaskId taskId = BackgroundTask.schedule((Instant)Instant.now().plusSeconds(1L), (IocTaskLambda & Serializable)x -> x.scheduleNewWork(5));
        Awaitility.await().atMost(Durations.ONE_MINUTE).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 6L);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTask() {
        BackgroundTask.scheduleRecurrently((String)every5Seconds, (IocTaskLambda & Serializable)x -> x.doWork(5));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTaskWithTaskContext() {
        BackgroundTask.scheduleRecurrently((String)every5Seconds, (IocTaskLambda & Serializable)x -> x.doWork((Integer)5, TaskContext.Null));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTaskWithId() {
        BackgroundTask.scheduleRecurrently((String)"theId", (String)every5Seconds, (IocTaskLambda & Serializable)x -> x.doWork(5));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTaskWithIdAndTimezone() {
        BackgroundTask.scheduleRecurrently((String)"theId", (String)every5Seconds, (ZoneId)ZoneId.systemDefault(), (IocTaskLambda & Serializable)x -> x.doWork(5));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringIntervalTask() {
        BackgroundTask.scheduleRecurrently((Duration)Duration.ofSeconds(5L), (IocTaskLambda & Serializable)x -> x.doWork(5));
        Awaitility.await().atMost(Duration.ofSeconds(15L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringIntervalTaskWithId() {
        BackgroundTask.scheduleRecurrently((String)"theId", (Duration)Duration.ofSeconds(5L), (IocTaskLambda & Serializable)x -> x.doWork(5));
        Awaitility.await().atMost(Duration.ofSeconds(15L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testDeleteOfRecurringTask() {
        String taskId = BackgroundTask.scheduleRecurrently((String)Cron.minutely(), (IocTaskLambda & Serializable)x -> x.doWork(5));
        BackgroundTask.delete((String)taskId);
        CarrotAssertions.assertThat(this.storageProvider.getRecurringTasks()).isEmpty();
    }

    @Test
    void recurringTaskIdIsKeptEvenIfBackgroundTaskServerRestarts() {
        BackgroundTask.scheduleRecurrently((String)"my-task-id", (String)every5Seconds, (IocTaskLambda & Serializable)x -> x.doWorkThatTakesLong(20));
        Awaitility.await().atMost(Duration.ofSeconds(6L)).until(() -> this.storageProvider.countTasks(StateName.PROCESSING) == 1L);
        UUID taskId = this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0).getId();
        this.backgroundTaskServer.stop();
        this.backgroundTaskServer.start();
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.getTaskById(taskId).hasState(StateName.SUCCEEDED));
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasRecurringTaskId("my-task-id").hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void mdcContextIsAvailableInTask() {
        MDC.put((String)"someKey", (String)"someValue");
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWorkWithMDC("someKey"));
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.storageProvider.getTaskById(taskId).hasState(StateName.SUCCEEDED));
    }

    @Test
    void mdcContextIsAvailableForDisplayName() {
        MDC.put((String)"customer.id", (String)"1");
        TaskId taskId = BackgroundTask.enqueue((IocTaskLambda & Serializable)x -> x.doWorkWithAnnotation(5, "John Doe"));
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasTaskName("Doing some hard work for user John Doe (customerId: 1)");
    }

    private Stream<UUID> getWorkStream() {
        return IntStream.range(0, 5).mapToObj(i -> UUID.randomUUID());
    }
}

