/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.storage.PartitionedStorageProviderForTest;
import cn.boboweike.carrot.fixtures.stubs.TestMDCTaskRequest;
import cn.boboweike.carrot.fixtures.stubs.TestTaskContextTaskRequest;
import cn.boboweike.carrot.fixtures.stubs.TestTaskRequest;
import cn.boboweike.carrot.fixtures.stubs.TestTaskRequestThatTakesLong;
import cn.boboweike.carrot.fixtures.tasks.stubs.SimpleTaskActivator;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.scheduling.BackgroundTaskRequest;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.tasks.states.StateName;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class BackgroundTaskByTaskRequestTest {
    private PartitionedStorageProviderForTest storageProvider;
    private BackgroundTaskServer backgroundTaskServer;
    private static final String every5Seconds = "*/5 * * * * *";

    @BeforeEach
    public void setUpTests() {
        this.storageProvider = new PartitionedStorageProviderForTest((PartitionedStorageProvider)new InMemoryPartitionedStorageProvider());
        SimpleTaskActivator taskActivator = new SimpleTaskActivator(new TestTaskRequest.TestTaskRequestHandler(), new TestTaskContextTaskRequest.TestTaskContextTaskRequestHandler());
        Carrot.configure().useTaskActivator((TaskActivator)taskActivator).useStorageProvider((PartitionedStorageProvider)this.storageProvider).useBackgroundTaskServer(BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration().andPollIntervalInSeconds(5)).initialize();
        this.backgroundTaskServer = Carrot.getBackgroundTaskServer();
    }

    @AfterEach
    public void cleanUp() {
        MDC.clear();
        Carrot.destroy();
    }

    @Test
    void ifBackgroundTaskIsNotConfiguredCorrectlyAnExceptionIsThrown() {
        BackgroundTaskRequest.setTaskRequestScheduler(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("not important"))).isInstanceOf(IllegalStateException.class)).hasMessage("The TaskRequestScheduler has not been initialized. Use the fluent Carrot.configure() API to setup Carrot or set the TaskRequestScheduler via the static setter method.");
    }

    @Test
    void testEnqueue() {
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("from testEnqueue"));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithId() {
        TaskId taskId = BackgroundTaskRequest.enqueue((UUID)UUID.randomUUID(), (TaskRequest)new TestTaskRequest("from testEnqueue"));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testEnqueueWithDisplayName() {
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("from testEnqueue"));
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasTaskName("Some neat Task Display Name");
    }

    @Test
    void testEnqueueOfFailingTaskAndRetryCount() {
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("from testEnqueue", true));
        Awaitility.await().atMost(15L, TimeUnit.SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.FAILED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED);
    }

    @Test
    void testEnqueueWithTaskContextAndMetadata() {
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("from testEnqueueWithTaskContextAndMetadata", 6L));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.PROCESSING);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> !this.storageProvider.getTaskById(taskId).getMetadata().isEmpty());
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasMetadata("test", "test");
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED).hasMetadataOnlyContainingTaskProgressAndLogging();
    }

    @Test
    void testEnqueueStreamWithMultipleParameters() {
        Stream<TaskRequest> workStream = this.getWorkStream();
        BackgroundTaskRequest.enqueue(workStream);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((Long)this.storageProvider.countTasks(StateName.SUCCEEDED)).isEqualTo(5L));
    }

    @Test
    void testScheduleWithZonedDateTime() {
        TaskId taskId = BackgroundTaskRequest.schedule((ZonedDateTime)ZonedDateTime.now().plusSeconds(7L), (TaskRequest)new TestTaskRequest("from testScheduleWithZonedDateTime"));
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithOffsetDateTime() {
        TaskId taskId = BackgroundTaskRequest.schedule((OffsetDateTime)OffsetDateTime.now().plusSeconds(7L), (TaskRequest)new TestTaskRequest("from testScheduleWithOffsetDateTime"));
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithLocalDateTime() {
        TaskId taskId = BackgroundTaskRequest.schedule((OffsetDateTime)OffsetDateTime.now().plusSeconds(7L), (TaskRequest)new TestTaskRequest("from testScheduleWithLocalDateTime"));
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleWithInstant() {
        TaskId taskId = BackgroundTaskRequest.schedule((OffsetDateTime)OffsetDateTime.now().plusSeconds(7L), (TaskRequest)new TestTaskRequest("from testScheduleWithInstant"));
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SUCCEEDED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testScheduleUsingDateTimeInTheFutureIsNotEnqueued() {
        TaskId taskId = BackgroundTaskRequest.schedule((Instant)Instant.now().plus(100L, ChronoUnit.DAYS), (TaskRequest)new TestTaskRequest("from testScheduleUsingDateTimeInTheFutureIsNotEnqueued"));
        Awaitility.await().during(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).until(() -> this.storageProvider.getTaskById(taskId).getState() == StateName.SCHEDULED);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.SCHEDULED);
    }

    @Test
    void testRecurringCronTask() {
        BackgroundTaskRequest.scheduleRecurrently((String)every5Seconds, (TaskRequest)new TestTaskRequest("from testRecurringTask"));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTaskWithId() {
        BackgroundTaskRequest.scheduleRecurrently((String)"theId", (String)every5Seconds, (TaskRequest)new TestTaskRequest("from testRecurringTaskWithId"));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringCronTaskWithIdAndTimezone() {
        BackgroundTaskRequest.scheduleRecurrently((String)"theId", (String)every5Seconds, (ZoneId)ZoneId.systemDefault(), (TaskRequest)new TestTaskRequest("from testRecurringTaskWithIdAndTimezone"));
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringIntervalTask() {
        BackgroundTaskRequest.scheduleRecurrently((Duration)Duration.ofSeconds(5L), (TaskRequest)new TestTaskRequest("from testRecurringTask"));
        Awaitility.await().atMost(Duration.ofSeconds(15L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testRecurringIntervalTaskWithId() {
        BackgroundTaskRequest.scheduleRecurrently((String)"theId", (Duration)Duration.ofSeconds(5L), (TaskRequest)new TestTaskRequest("from testRecurringTaskWithId"));
        Awaitility.await().atMost(Duration.ofSeconds(15L)).until(() -> this.storageProvider.countTasks(StateName.SUCCEEDED) == 1L);
        Task task = this.storageProvider.getTasksByPartition(StateName.SUCCEEDED, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @Test
    void testDeleteOfRecurringTask() {
        BackgroundTaskRequest.scheduleRecurrently((String)"theId", (String)Cron.minutely(), (ZoneId)ZoneId.systemDefault(), (TaskRequest)new TestTaskRequest("from testRecurringTaskWithIdAndTimezone"));
        BackgroundTask.delete((String)"theId");
        CarrotAssertions.assertThat(this.storageProvider.getRecurringTasks()).isEmpty();
    }

    @Test
    void recurringTaskIdIsKeptEvenIfBackgroundTaskServerRestarts() {
        BackgroundTaskRequest.scheduleRecurrently((String)"my-task-id", (String)every5Seconds, (TaskRequest)new TestTaskRequestThatTakesLong("from recurringTaskIdIsKeptEvenIfBackgroundTaskServerRestarts", 20));
        Awaitility.await().atMost(Duration.ofSeconds(6L)).until(() -> this.storageProvider.countTasks(StateName.PROCESSING) == 1L);
        UUID taskId = this.storageProvider.getTasksByPartition(StateName.PROCESSING, PageRequest.ascOnUpdatedAt((int)1000), 0).get(0).getId();
        this.backgroundTaskServer.stop();
        this.backgroundTaskServer.start();
        Awaitility.await().atMost(Duration.ofSeconds(25L)).until(() -> this.storageProvider.getTaskById(taskId).hasState(StateName.SUCCEEDED));
        Task task = this.storageProvider.getTaskById(taskId);
        CarrotAssertions.assertThat(task).hasRecurringTaskId("my-task-id").hasStates(StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING, StateName.SUCCEEDED);
    }

    @RepeatedIfExceptionsTest(repeats=3)
    void taskCanBeDeletedWhenEnqueued() {
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskRequest("input"));
        BackgroundTaskRequest.delete((TaskId)taskId);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).untilAsserted(() -> {
            CarrotAssertions.assertThat((int)this.backgroundTaskServer.getTaskZooKeeper().getOccupiedWorkerCount()).isZero();
            CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasStates(StateName.ENQUEUED, StateName.DELETED);
        });
    }

    @Test
    void mdcContextIsAvailableInTask() {
        MDC.put((String)"someKey", (String)"someValue");
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestMDCTaskRequest("someKey"));
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.storageProvider.getTaskById(taskId).hasState(StateName.SUCCEEDED));
    }

    @Test
    void mdcContextIsAvailableForDisplayName() {
        MDC.put((String)"customer.id", (String)"1");
        TaskId taskId = BackgroundTaskRequest.enqueue((TaskRequest)new TestMDCTaskRequest("someKey"));
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(taskId)).hasTaskName("Doing some hard work for customerId: 1");
    }

    @Test
    void testTaskContextIsThreadSafe() {
        TaskId taskId1 = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskContextTaskRequest());
        TaskId taskId2 = BackgroundTaskRequest.enqueue((TaskRequest)new TestTaskContextTaskRequest());
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId1).getState() == StateName.FAILED);
        Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.storageProvider.getTaskById(taskId2).getState() == StateName.FAILED);
        Task task1ById = this.storageProvider.getTaskById(taskId1);
        CarrotAssertions.assertThat(task1ById).hasMetadata(this.allValuesAre(taskId1.asUUID())).hasMetadata(this.noValueMatches(taskId2.asUUID()));
        Task task2ById = this.storageProvider.getTaskById(taskId2);
        CarrotAssertions.assertThat(task2ById).hasMetadata(this.allValuesAre(taskId2.asUUID())).hasMetadata(this.noValueMatches(taskId1.asUUID()));
    }

    Condition<Map<String, Object>> noValueMatches(UUID id) {
        return new Condition(s -> !s.containsValue(id), "a value matches %s", new Object[]{id});
    }

    Condition<Map<String, Object>> allValuesAre(UUID id) {
        return new Condition(s -> new HashSet(s.values()).size() == 2 && new HashSet(s.values()).contains(id), "a value matches %s", new Object[]{id});
    }

    private Stream<TaskRequest> getWorkStream() {
        return Stream.of(new TestTaskRequest("Workstream item 1"), new TestTaskRequest("Workstream item 2"), new TestTaskRequest("Workstream item 3"), new TestTaskRequest("Workstream item 4"), new TestTaskRequest("Workstream item 5"));
    }
}

