/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.scheduling.TaskScheduler;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.ApplyStateFilter;
import cn.boboweike.carrot.tasks.filters.ElectStateFilter;
import cn.boboweike.carrot.tasks.filters.TaskClientFilter;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambdaFromStream;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.MDC;

@ExtendWith(value={MockitoExtension.class})
public class TaskSchedulerTest {
    @Mock
    private PartitionedStorageProvider storageProvider;
    private TestService testService;
    private TaskScheduler taskScheduler;
    private TaskClientLogFilter taskClientLogFilter;

    @BeforeEach
    void setupTestService() {
        this.testService = new TestService();
        this.taskClientLogFilter = new TaskClientLogFilter();
        this.taskScheduler = new TaskScheduler(this.storageProvider, List.of(this.taskClientLogFilter));
    }

    @Test
    void onSaveTaskCreatingAndCreatedAreCalled() {
        Mockito.when((Object)this.storageProvider.save((Task)ArgumentMatchers.any(Task.class))).thenAnswer(invocation -> invocation.getArgument(0));
        this.taskScheduler.enqueue((TaskLambda & Serializable)() -> this.testService.doWork());
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreating).isTrue();
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreated).isTrue();
    }

    @Test
    void onSaveTaskMDCDataIsPutIntoTask() {
        ArgumentCaptor taskArgumentCaptor = ArgumentCaptor.forClass(Task.class);
        MDC.put((String)"some-key", (String)"some-value");
        Mockito.when((Object)this.storageProvider.save((Task)taskArgumentCaptor.capture())).thenAnswer(invocation -> invocation.getArgument(0));
        this.taskScheduler.enqueue((TaskLambda & Serializable)() -> this.testService.doWork());
        Task task = (Task)taskArgumentCaptor.getValue();
        Assertions.assertThat((Map)task.getMetadata()).containsKey((Object)"mdc-some-key");
    }

    @Test
    void onDeleteTaskStateElectionAndStateAppliedAreCalled() {
        Task enqueuedTask = TaskTestBuilder.anEnqueuedTask().build();
        Mockito.when((Object)this.storageProvider.save((Task)ArgumentMatchers.any(Task.class))).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.storageProvider.getTaskById(enqueuedTask.getId())).thenReturn((Object)enqueuedTask);
        this.taskScheduler.delete(enqueuedTask.getId());
        Assertions.assertThat((boolean)this.taskClientLogFilter.onStateElection).isTrue();
        Assertions.assertThat((boolean)this.taskClientLogFilter.onStateApplied).isTrue();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).save((Task)ArgumentMatchers.any(Task.class));
    }

    @Test
    void onStreamOfTasksCreatingAndCreatedAreCalled() {
        Mockito.when((Object)this.storageProvider.save(ArgumentMatchers.anyList())).thenAnswer(invocation -> invocation.getArgument(0));
        Stream<Integer> range = IntStream.range(0, 1).boxed();
        this.taskScheduler.enqueue(range, (TaskLambdaFromStream & Serializable)i -> this.testService.doWork((Integer)i));
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreating).isTrue();
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreated).isTrue();
    }

    @Test
    void onRecurringTaskCreatingAndCreatedAreCalled() {
        Mockito.when((Object)this.storageProvider.saveRecurringTask((RecurringTask)ArgumentMatchers.any(RecurringTask.class))).thenAnswer(invocation -> invocation.getArgument(0));
        this.taskScheduler.scheduleRecurrently(Cron.daily(), (TaskLambda & Serializable)() -> this.testService.doWork());
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreating).isTrue();
        Assertions.assertThat((boolean)this.taskClientLogFilter.onCreated).isTrue();
    }

    private static class TaskClientLogFilter
    implements TaskClientFilter,
    ElectStateFilter,
    ApplyStateFilter {
        private boolean onCreating;
        private boolean onCreated;
        private boolean onStateElection;
        private boolean onStateApplied;

        private TaskClientLogFilter() {
        }

        public void onCreating(AbstractTask task) {
            this.onCreating = true;
        }

        public void onCreated(AbstractTask task) {
            this.onCreated = true;
        }

        public void onStateElection(Task task, TaskState newState) {
            this.onStateElection = true;
        }

        public void onStateApplied(Task task, TaskState oldState, TaskState newState) {
            this.onStateApplied = true;
        }
    }
}

