/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling.cron;

import cn.boboweike.carrot.scheduling.cron.Cron;
import java.time.DayOfWeek;
import java.time.Month;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CronTest {
    CronTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"getCronExpressionsAndTheirValue"})
    void testCron(String cronExpression, String expectedResult) {
        Assertions.assertThat((String)cronExpression).isEqualTo(expectedResult);
    }

    static Stream<Arguments> getCronExpressionsAndTheirValue() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{Cron.daily(), "0 0 * * *"}), Arguments.arguments((Object[])new Object[]{Cron.daily((int)3), "0 3 * * *"}), Arguments.arguments((Object[])new Object[]{Cron.daily((int)3, (int)17), "17 3 * * *"}), Arguments.arguments((Object[])new Object[]{Cron.hourly(), "0 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.hourly((int)9), "9 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.minutely(), "* * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.every15seconds(), "*/15 * * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.every30seconds(), "*/30 * * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.every5minutes(), "*/5 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.every10minutes(), "*/10 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.every15minutes(), "*/15 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.everyHalfHour(), "*/30 * * * *"}), Arguments.arguments((Object[])new Object[]{Cron.weekly(), "0 0 * * 1"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.TUESDAY), "0 0 * * 2"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.TUESDAY, (int)8), "0 8 * * 2"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.TUESDAY, (int)8, (int)15), "15 8 * * 2"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.SUNDAY), "0 0 * * 0"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.SUNDAY, (int)8), "0 8 * * 0"}), Arguments.arguments((Object[])new Object[]{Cron.weekly((DayOfWeek)DayOfWeek.SUNDAY, (int)8, (int)15), "15 8 * * 0"}), Arguments.arguments((Object[])new Object[]{Cron.monthly(), "0 0 1 * *"}), Arguments.arguments((Object[])new Object[]{Cron.monthly((int)4), "0 0 4 * *"}), Arguments.arguments((Object[])new Object[]{Cron.monthly((int)6, (int)9), "0 9 6 * *"}), Arguments.arguments((Object[])new Object[]{Cron.monthly((int)6, (int)9, (int)12), "12 9 6 * *"}), Arguments.arguments((Object[])new Object[]{Cron.lastDayOfTheMonth(), "0 0 L * *"}), Arguments.arguments((Object[])new Object[]{Cron.lastDayOfTheMonth((int)10), "0 10 L * *"}), Arguments.arguments((Object[])new Object[]{Cron.lastDayOfTheMonth((int)10, (int)10), "10 10 L * *"}), Arguments.arguments((Object[])new Object[]{Cron.yearly(), "0 0 1 1 *"}), Arguments.arguments((Object[])new Object[]{Cron.yearly((Month)Month.FEBRUARY), "0 0 1 2 *"}), Arguments.arguments((Object[])new Object[]{Cron.yearly((Month)Month.FEBRUARY, (int)12), "0 0 12 2 *"}), Arguments.arguments((Object[])new Object[]{Cron.yearly((Month)Month.FEBRUARY, (int)12, (int)7), "0 7 12 2 *"}), Arguments.arguments((Object[])new Object[]{Cron.yearly((Month)Month.FEBRUARY, (int)12, (int)7, (int)6), "6 7 12 2 *"}));
    }
}

