/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.scheduling.exceptions;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.scheduling.exceptions.TaskNotFoundException;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaskNotFoundExceptionTest {
    @Test
    void shouldReturnCorrectMessageForClassThatDoesNotExist() {
        TaskNotFoundException taskNotFoundException = new TaskNotFoundException(TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails().build());
        Assertions.assertThat((Throwable)taskNotFoundException).hasMessage("i.dont.exist.Class.notImportant(java.lang.Integer)");
    }

    @Test
    void shouldReturnCorrectMessageForMethodThatDoesNotExist() {
        TaskNotFoundException taskNotFoundException = new TaskNotFoundException(TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails().build());
        Assertions.assertThat((Throwable)taskNotFoundException).hasMessage("cn.boboweike.carrot.fixtures.stubs.TestService.doWorkThatDoesNotExist(java.lang.Integer)");
    }

    @Test
    void shouldReturnCorrectMessageForTaskParameterThatDoesNotExist() {
        TaskNotFoundException taskNotFoundException = new TaskNotFoundException(TaskDetailsTestBuilder.taskParameterThatDoesNotExistTaskDetails().build());
        Assertions.assertThat((Throwable)taskNotFoundException).hasMessage("cn.boboweike.carrot.fixtures.stubs.TestService.doWork(i.dont.exist.Class)");
    }

    @Test
    void shouldReturnCorrectMessageForTaskParameterNotDeserializableException() {
        TaskNotFoundException taskNotFoundException = new TaskNotFoundException(TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").withTaskParameter(new TaskParameterNotDeserializableException("i.dont.exist.Class", "Class not found")).build());
        Assertions.assertThat((Throwable)taskNotFoundException).hasMessage("cn.boboweike.carrot.fixtures.stubs.TestService.doWork(i.dont.exist.Class)\n\tcaused by: one of the TaskParameters is not deserializable anymore");
    }
}

