/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import ch.qos.logback.LoggerAssert;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.BackgroundTaskPerformer;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskTestFilter;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.runner.BackgroundStaticFieldTaskWithoutIocRunner;
import cn.boboweike.carrot.server.runner.BackgroundTaskRunner;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.states.FailedState;
import cn.boboweike.carrot.tasks.states.IllegalTaskStateChangeException;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BackgroundTaskPerformerTest {
    @Mock
    private BackgroundTaskServer backgroundTaskServer;
    @Mock
    private PartitionedStorageProvider storageProvider;
    @Mock
    private TaskZooKeeper taskZooKeeper;
    private BackgroundTaskTestFilter logAllStateChangesFilter;

    @BeforeEach
    void setUpMocks() {
        this.logAllStateChangesFilter = new BackgroundTaskTestFilter();
        Mockito.when((Object)this.backgroundTaskServer.getStorageProvider()).thenReturn((Object)this.storageProvider);
        Mockito.when((Object)this.backgroundTaskServer.getTaskZooKeeper()).thenReturn((Object)this.taskZooKeeper);
        Mockito.when((Object)this.backgroundTaskServer.getTaskFilters()).thenReturn((Object)new TaskDefaultFilters(new TaskFilter[]{this.logAllStateChangesFilter}));
    }

    @Test
    void onSuccessAfterDeleteTheIllegalTaskStateChangeIsCatchedAndLogged() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.mockBackgroundTaskRunner(task, taskFromStorage -> taskFromStorage.delete("for testing"));
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        ListAppender<ILoggingEvent> logger = LoggerAssert.initFor(backgroundTaskPerformer);
        backgroundTaskPerformer.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"ENQUEUED->PROCESSING"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isTrue();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isTrue();
        CarrotAssertions.assertThat(logger).hasNoErrorLogMessages().hasInfoMessage("Task finished successfully but it was already deleted - ignoring illegal state change from DELETED to SUCCEEDED");
    }

    @Test
    void onSuccessIllegalTaskStateChangeIsThrown() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.mockBackgroundTaskRunner(task, taskFromStorage -> taskFromStorage.failed("boe", new Exception()));
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        Assertions.assertThatThrownBy(() -> backgroundTaskPerformer.run()).isInstanceOf(IllegalTaskStateChangeException.class);
    }

    @Test
    void onFailureAfterDeleteTheIllegalTaskStateChangeIsCatchedAndLogged() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.mockBackgroundTaskRunner(task, taskFromStorage -> {
            taskFromStorage.delete("for testing");
            taskFromStorage.delete("to throw exception that will bring it to failed state");
        });
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        ListAppender<ILoggingEvent> logger = LoggerAssert.initFor(backgroundTaskPerformer);
        backgroundTaskPerformer.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"ENQUEUED->PROCESSING"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isTrue();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isFalse();
        CarrotAssertions.assertThat(logger).hasNoErrorLogMessages().hasInfoMessage("Task processing failed but it was already deleted - ignoring illegal state change from DELETED to FAILED");
    }

    @Test
    void onFailureIllegalTaskStateChangeIsThrown() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.mockBackgroundTaskRunner(task, taskFromStorage -> {
            taskFromStorage.succeeded();
            taskFromStorage.succeeded();
        });
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        Assertions.assertThatThrownBy(() -> backgroundTaskPerformer.run()).isInstanceOf(IllegalTaskStateChangeException.class);
    }

    @Test
    void allStateChangesArePassingViaTheApplyStateFilterOnSuccess() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn((Object)new BackgroundStaticFieldTaskWithoutIocRunner());
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        backgroundTaskPerformer.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"ENQUEUED->PROCESSING", "PROCESSING->SUCCEEDED"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isTrue();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isTrue();
    }

    @Test
    void allStateChangesArePassingViaTheApplyStateFilterOnFailure() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn(null);
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        ListAppender<ILoggingEvent> logger = LoggerAssert.initFor(backgroundTaskPerformer);
        backgroundTaskPerformer.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"ENQUEUED->PROCESSING", "PROCESSING->FAILED", "FAILED->SCHEDULED"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isTrue();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isFalse();
        CarrotAssertions.assertThat(logger).hasNoErrorLogMessages().hasWarningMessageContaining("processing failed: An exception occurred during the performance of the task");
    }

    @Test
    void onFailureAfterAllRetriesExceptionIsLoggedToError() {
        Task task = TaskTestBuilder.aFailedTaskWithRetries().withEnqueuedState(Instant.now()).build();
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn(null);
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        ListAppender<ILoggingEvent> logger = LoggerAssert.initFor(backgroundTaskPerformer);
        backgroundTaskPerformer.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"ENQUEUED->PROCESSING", "PROCESSING->FAILED"});
        CarrotAssertions.assertThat(logger).hasNoWarnLogMessages().hasErrorMessage(String.format("Task(id=%s, taskName='failed task') processing failed: An exception occurred during the performance of the task", task.getId()));
    }

    @Test
    void onConcurrentTaskModificationExceptionAllIsStillOk() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Integer partition = 0;
        Mockito.when((Object)this.backgroundTaskServer.getPartition()).thenReturn((Object)partition);
        Mockito.when((Object)this.storageProvider.saveByPartition(task, partition)).thenReturn((Object)task).thenThrow(new Throwable[]{new ConcurrentTaskModificationException(task)});
        this.mockBackgroundTaskRunner(task, task1 -> {});
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        backgroundTaskPerformer.run();
    }

    @Test
    @DisplayName(value="InvocationTargetException is unwrapped and the actual error is stored instead")
    void invocationTargetExceptionUnwrapped() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        BackgroundTaskRunner runner = (BackgroundTaskRunner)Mockito.mock(BackgroundTaskRunner.class);
        ((BackgroundTaskRunner)Mockito.doThrow((Throwable[])new Throwable[]{new InvocationTargetException(new RuntimeException("test error"))}).when((Object)runner)).run(task);
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn((Object)runner);
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        backgroundTaskPerformer.run();
        Optional lastFailure = task.getLastTaskStateOfType(FailedState.class);
        CarrotAssertions.assertThat((boolean)lastFailure.isPresent()).isTrue();
        CarrotAssertions.assertThat((String)((FailedState)lastFailure.get()).getExceptionMessage()).isEqualTo("test error");
        CarrotAssertions.assertThat((Throwable)((FailedState)lastFailure.get()).getException()).isInstanceOf(RuntimeException.class);
        CarrotAssertions.assertThat((String)((FailedState)lastFailure.get()).getException().getMessage()).isEqualTo("test error");
    }

    @Test
    @DisplayName(value="any exception other than InvocationTargetException stays unwrapped")
    void anyExceptionOtherThanInvocationTargetExceptionIsNotUnwrapped() throws Exception {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        BackgroundTaskRunner runner = (BackgroundTaskRunner)Mockito.mock(BackgroundTaskRunner.class);
        ((BackgroundTaskRunner)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("test error")}).when((Object)runner)).run(task);
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn((Object)runner);
        BackgroundTaskPerformer backgroundTaskPerformer = new BackgroundTaskPerformer(this.backgroundTaskServer, task);
        backgroundTaskPerformer.run();
        Optional lastFailure = task.getLastTaskStateOfType(FailedState.class);
        CarrotAssertions.assertThat((boolean)lastFailure.isPresent()).isTrue();
        CarrotAssertions.assertThat((String)((FailedState)lastFailure.get()).getExceptionMessage()).isEqualTo("test error");
        CarrotAssertions.assertThat((Throwable)((FailedState)lastFailure.get()).getException()).isInstanceOf(RuntimeException.class);
        CarrotAssertions.assertThat((String)((FailedState)lastFailure.get()).getException().getMessage()).isEqualTo("test error");
    }

    private void mockBackgroundTaskRunner(Task task, Consumer<Task> taskConsumer) throws Exception {
        BackgroundTaskRunner backgroundTaskRunnerMock = (BackgroundTaskRunner)Mockito.mock(BackgroundTaskRunner.class);
        ((BackgroundTaskRunner)Mockito.doAnswer(invocation -> {
            Task taskArgument = (Task)invocation.getArgument(0, Task.class);
            taskConsumer.accept(taskArgument);
            return null;
        }).when((Object)backgroundTaskRunnerMock)).run((Task)Mockito.any());
        Mockito.when((Object)this.backgroundTaskServer.getBackgroundTaskRunner(task)).thenReturn((Object)backgroundTaskRunnerMock);
    }
}

