/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackgroundTaskServerConfigurationTest {
    private BackgroundTaskServerConfiguration backgroundTaskServerConfiguration = BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration();

    @Test
    void ifDefaultPollIntervalInSecondsSmallerThan5ThenThrowException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.backgroundTaskServerConfiguration.andPollIntervalInSeconds(4)).isInstanceOf(IllegalArgumentException.class)).hasMessage("The pollIntervalInSeconds can not be smaller than 5 - otherwise it will cause too much load on your SQL/noSQL datastore.");
    }

    @Test
    void ifDefaultPollIntervalInSeconds5OrHigherThenNoException() {
        Assertions.assertThatCode(() -> this.backgroundTaskServerConfiguration.andPollIntervalInSeconds(5)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.backgroundTaskServerConfiguration.andPollIntervalInSeconds(15)).doesNotThrowAnyException();
    }
}

