/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import ch.qos.logback.LoggerAssert;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.storage.BackgroundTaskServerStatusTestBuilder;
import cn.boboweike.carrot.fixtures.utils.SleepUtils;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.GCUtils;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public class ServerZooKeeperTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerZooKeeperTest.class);
    private static final Integer PARTITION0 = 0;
    private PartitionedStorageProvider storageProvider;
    private BackgroundTaskServer backgroundTaskServer;
    @Captor
    private ArgumentCaptor<CarrotMetadata> carrotMetadataToSaveArgumentCaptor;

    @BeforeEach
    void setUp() {
        this.storageProvider = (PartitionedStorageProvider)Mockito.spy((Object)new InMemoryPartitionedStorageProvider());
        JacksonJsonMapper jsonMapper = new JacksonJsonMapper();
        this.storageProvider.setTaskMapper(new TaskMapper((JsonMapper)jsonMapper));
        this.backgroundTaskServer = new BackgroundTaskServer(this.storageProvider, null, BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration().andPollIntervalInSeconds(5).andWorkerCount(10));
    }

    @AfterEach
    void tearDown() {
        try {
            this.backgroundTaskServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void onStartServerAnnouncesItself() {
        this.backgroundTaskServer.start();
        Awaitility.await().untilAsserted(() -> CarrotAssertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.backgroundTaskServer.isAnnounced()).isTrue());
        CarrotAssertions.assertThat((Integer)this.backgroundTaskServer.getPartition()).isEqualTo((Object)PARTITION0);
    }

    @Test
    void onStartServerAnnouncesItselfAndDoesNotGetPartitionIfItIsNotTheFirstToBeOnline() {
        BackgroundTaskServer anotherServer = this.getOneServer();
        anotherServer.start();
        Awaitility.await().untilAsserted(() -> CarrotAssertions.assertThat((boolean)anotherServer.isAnnounced()).isTrue());
        CarrotAssertions.assertThat((Integer)anotherServer.getPartition()).isEqualTo((Object)PARTITION0);
        this.backgroundTaskServer.start();
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(2));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.backgroundTaskServer.isAnnounced()).isTrue());
        CarrotAssertions.assertThat((Integer)this.backgroundTaskServer.getPartition()).isEqualTo((Object)BackgroundTaskServer.NO_PARTITION);
        anotherServer.stop();
    }

    @Test
    void serverKeepsSignalingItsAlive() {
        this.backgroundTaskServer.start();
        SleepUtils.sleep(1000L);
        Awaitility.await().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((Instant)((BackgroundTaskServerStatus)this.storageProvider.getBackgroundTaskServers().get(0)).getLastHeartbeat()).isCloseTo((Temporal)Instant.now(), (TemporalOffset)Assertions.within((long)500L, (TemporalUnit)ChronoUnit.MILLIS)));
    }

    @Test
    void oneBackgroundTaskServerDoesZookeepingAndKeepsItsAnnouncedStatus() {
        this.backgroundTaskServer.start();
        this.storageProvider.announceBackgroundTaskServer(this.anotherServerStatus());
        Awaitility.await().pollInterval(Durations.ONE_SECOND).atLeast(20L, TimeUnit.SECONDS).atMost(55L, TimeUnit.SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1));
        CarrotAssertions.assertThat((boolean)this.backgroundTaskServer.isAnnounced()).isTrue();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.atLeastOnce())).removeTimedOutBackgroundTaskServers((Instant)ArgumentMatchers.any());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.atMost((int)2))).removeTimedOutBackgroundTaskServers((Instant)ArgumentMatchers.any());
    }

    @Test
    void otherServersDoZookeepingAndGetAnnouncedIfOneServerStops() {
        BackgroundTaskServer oneServer = this.getOneServer();
        oneServer.start();
        Awaitility.await().atMost(Durations.TWO_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((boolean)oneServer.isAnnounced()).isTrue());
        CarrotAssertions.assertThat((Integer)oneServer.getPartition()).isEqualTo((Object)PARTITION0);
        BackgroundTaskServer otherServer = this.backgroundTaskServer;
        otherServer.start();
        Awaitility.await().untilAsserted(() -> CarrotAssertions.assertThat((boolean)otherServer.isAnnounced()).isTrue());
        CarrotAssertions.assertThat((Integer)otherServer.getPartition()).isEqualTo((Object)BackgroundTaskServer.NO_PARTITION);
        oneServer.stop();
        Awaitility.await().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1));
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> CarrotAssertions.assertThat((boolean)otherServer.isAnnounced()).isTrue());
        Awaitility.await().untilAsserted(() -> CarrotAssertions.assertThat((Integer)otherServer.getPartition()).isEqualTo((Object)PARTITION0));
    }

    @Test
    void aServerThatSignalsItsAliveAlthoughItTimedoutAlwaysRestarts() {
        this.backgroundTaskServer.start();
        SleepUtils.sleep(100L);
        for (int i = 0; i < 3; ++i) {
            this.storageProvider.removeTimedOutBackgroundTaskServers(Instant.now());
            Awaitility.await().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).atMost(6L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((List)this.storageProvider.getBackgroundTaskServers()).hasSize(1));
            Awaitility.await().untilAsserted(() -> Assertions.assertThat((boolean)this.backgroundTaskServer.isAnnounced()).isTrue());
            Awaitility.await().untilAsserted(() -> Assertions.assertThat((Integer)this.backgroundTaskServer.getPartition()).isEqualTo((Object)PARTITION0));
        }
    }

    @Test
    void serverIsNotAnnouncedIfServerZooKeeperCrashes() {
        ((PartitionedStorageProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException()}).when((Object)this.storageProvider)).announceBackgroundTaskServer((BackgroundTaskServerStatus)ArgumentMatchers.any());
        this.backgroundTaskServer.start();
        SleepUtils.sleep(5000L);
        Awaitility.await().untilAsserted(() -> CarrotAssertions.assertThat((boolean)this.backgroundTaskServer.isAnnounced()).isFalse());
    }

    @Test
    void backgroundTaskServerSignalsItIsStoppedWhenItIsStopped() {
        this.backgroundTaskServer.start();
        Awaitility.await().untilAsserted(() -> ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).announceBackgroundTaskServer((BackgroundTaskServerStatus)ArgumentMatchers.any()));
        this.backgroundTaskServer.stop();
        Awaitility.await().untilAsserted(() -> ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).signalBackgroundTaskServerStopped((BackgroundTaskServerStatus)ArgumentMatchers.any()));
    }

    @RepeatedIfExceptionsTest
    public void testLongGCDoesNotStopCarrot() throws InterruptedException {
        Object serverZooKeeper = Whitebox.getInternalState(this.backgroundTaskServer, "serverZooKeeper");
        ListAppender<ILoggingEvent> zookeeperLogger = LoggerAssert.initFor(serverZooKeeper);
        this.backgroundTaskServer.start();
        LOGGER.info("Let Carrot startup");
        Thread.sleep(2000L);
        GCUtils.simulateStopTheWorldGC(25000L);
        LOGGER.info("Let Carrot recover");
        Thread.sleep(2000L);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> CarrotAssertions.assertThat(zookeeperLogger).hasNoErrorMessageContaining("An unrecoverable error occurred, try next run."));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.atLeastOnce())).saveMetadata((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.capture());
        CarrotMetadata carrotMetadata = (CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.getValue();
        CarrotAssertions.assertThat((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.getValue()).hasName(CpuAllocationIrregularityNotification.class.getSimpleName()).hasOwner("BackgroundTaskServer " + this.backgroundTaskServer.getId().toString());
    }

    private BackgroundTaskServer getOneServer() {
        return new BackgroundTaskServer(this.storageProvider, null, BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration().andPollIntervalInSeconds(5).andWorkerCount(10));
    }

    private BackgroundTaskServerStatus anotherServerStatus() {
        return BackgroundTaskServerStatusTestBuilder.aFastBackgroundTaskServerStatus().withIsStarted().build();
    }
}

