/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server;

import ch.qos.logback.LoggerAssert;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.storage.BackgroundTaskServerStatusTestBuilder;
import cn.boboweike.carrot.fixtures.stubs.TestServiceInterface;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.fixtures.utils.SleepUtils;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.BackgroundTaskServerConfiguration;
import cn.boboweike.carrot.server.BackgroundTaskTestFilter;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.dashboard.DashboardNotificationManager;
import cn.boboweike.carrot.server.strategy.WorkDistributionStrategy;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TaskZooKeeperTest {
    @Mock
    private PartitionedStorageProvider storageProvider;
    @Mock
    private BackgroundTaskServer backgroundTaskServer;
    @Mock
    private WorkDistributionStrategy workDistributionStrategy;
    @Captor
    private ArgumentCaptor<List<Task>> tasksToSaveArgumentCaptor;
    @Captor
    private ArgumentCaptor<CarrotMetadata> carrotMetadataArgumentCaptor;
    private BackgroundTaskServerStatus backgroundTaskServerStatus;
    private TaskZooKeeper taskZooKeeper;
    private BackgroundTaskTestFilter logAllStateChangesFilter;
    private ListAppender<ILoggingEvent> logger;
    private static Integer PARTITION0 = 0;

    @BeforeEach
    void setUpBackgroundTaskZooKeeper() {
        Mockito.when((Object)this.backgroundTaskServer.getConfiguration()).thenReturn((Object)BackgroundTaskServerConfiguration.usingStandardBackgroundTaskServerConfiguration());
        this.logAllStateChangesFilter = new BackgroundTaskTestFilter();
        this.backgroundTaskServerStatus = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.taskZooKeeper = this.initializeTaskZooKeeper();
        this.logger = LoggerAssert.initFor(this.taskZooKeeper);
    }

    @Test
    void taskZooKeeperDoesNothingIfItIsNotInitialized() {
        Mockito.when((Object)this.backgroundTaskServer.isUnAnnounced()).thenReturn((Object)true);
        this.taskZooKeeper.run();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.storageProvider});
    }

    @Test
    void tasksThatAreProcessedAreBeingUpdatedWithAHeartbeat() {
        Task task = TaskTestBuilder.anEnqueuedTask().withId().build();
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task));
        task.startProcessingOn(this.backgroundTaskServer);
        this.taskZooKeeper.startProcessing(task, (Thread)Mockito.mock(Thread.class));
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        ProcessingState processingState = (ProcessingState)task.getTaskState();
        CarrotAssertions.assertThat((Instant)processingState.getUpdatedAt()).isAfter(processingState.getCreatedAt());
    }

    @Test
    void noExceptionIsThrownIfATaskHasSucceededWhileUpdateProcessingIsCalled() {
        Task task = TaskTestBuilder.anEnqueuedTask().withId().build();
        task.startProcessingOn(this.backgroundTaskServer);
        this.taskZooKeeper.startProcessing(task, (Thread)Mockito.mock(Thread.class));
        task.succeeded();
        this.taskZooKeeper.run();
        CarrotAssertions.assertThat(this.logger).hasNoWarnLogMessages();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
    }

    @Test
    void evenWhenNoWorkCanBeOnboardedTasksThatAreProcessedAreBeingUpdatedWithAHeartbeat() {
        this.backgroundTaskServerStatus = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withWorkerSize(0).build();
        this.taskZooKeeper = this.initializeTaskZooKeeper();
        Task task = TaskTestBuilder.anEnqueuedTask().withId().build();
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task));
        task.startProcessingOn(this.backgroundTaskServer);
        this.taskZooKeeper.startProcessing(task, (Thread)Mockito.mock(Thread.class));
        this.taskZooKeeper.run();
        this.taskZooKeeper.startProcessing(TaskTestBuilder.aTaskInProgress().build(), (Thread)Mockito.mock(Thread.class));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        ProcessingState processingState = (ProcessingState)task.getTaskState();
        CarrotAssertions.assertThat((Instant)processingState.getUpdatedAt()).isAfter(processingState.getCreatedAt());
    }

    @Test
    void tasksThatAreBeingProcessedButHaveBeenDeletedViaDashboardWillBeInterrupted() {
        Task task = TaskTestBuilder.anEnqueuedTask().withId().build();
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task));
        ((PartitionedStorageProvider)Mockito.doThrow((Throwable[])new Throwable[]{new ConcurrentTaskModificationException(task)}).when((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        Mockito.when((Object)this.storageProvider.getTaskById(task.getId())).thenReturn((Object)TaskTestBuilder.aCopyOf(task).withDeletedState().build());
        Thread threadMock = (Thread)Mockito.mock(Thread.class);
        task.startProcessingOn(this.backgroundTaskServer);
        this.taskZooKeeper.startProcessing(task, threadMock);
        this.taskZooKeeper.run();
        CarrotAssertions.assertThat(this.logger).hasNoWarnLogMessages();
        CarrotAssertions.assertThat(task).hasState(StateName.DELETED);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        ((Thread)Mockito.verify((Object)threadMock)).interrupt();
    }

    @Test
    void tasksThatAreBeingProcessedButArePermanentlyDeletedViaAPIWillBeInterrupted() {
        Task task = TaskTestBuilder.anEnqueuedTask().withId().build();
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task));
        ((PartitionedStorageProvider)Mockito.doThrow((Throwable[])new Throwable[]{new ConcurrentTaskModificationException(task)}).when((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        Mockito.when((Object)this.storageProvider.getTaskById(task.getId())).thenThrow(new Throwable[]{new TaskNotFoundException(task.getId())});
        Thread threadMock = (Thread)Mockito.mock(Thread.class);
        task.startProcessingOn(this.backgroundTaskServer);
        this.taskZooKeeper.startProcessing(task, threadMock);
        this.taskZooKeeper.run();
        CarrotAssertions.assertThat(this.logger).hasNoWarnLogMessages();
        CarrotAssertions.assertThat(task).hasState(StateName.DELETED);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(Collections.singletonList(task), PARTITION0);
        ((Thread)Mockito.verify((Object)threadMock)).interrupt();
    }

    @Test
    void checkForRecurringTasks() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withCronExpression("*/5 * * * * *").build();
        Mockito.when((Object)this.storageProvider.countRecurringTasksByPartition(PARTITION0)).thenReturn((Object)1L);
        Mockito.when((Object)this.storageProvider.getRecurringTasksByPartition(PARTITION0)).thenReturn(List.of(recurringTask));
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition((List)this.tasksToSaveArgumentCaptor.capture(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        Task savedTask = (Task)((List)this.tasksToSaveArgumentCaptor.getValue()).get(0);
        CarrotAssertions.assertThat(savedTask).hasState(StateName.SCHEDULED).hasRecurringTaskId(recurringTask.getId());
    }

    @Test
    void recurringTasksAreCached() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withCronExpression("*/5 * * * * *").build();
        Mockito.when((Object)this.storageProvider.countRecurringTasksByPartition(PARTITION0)).thenReturn((Object)1L);
        Mockito.when((Object)this.storageProvider.getRecurringTasksByPartition(PARTITION0)).thenReturn(List.of(recurringTask));
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)1))).countRecurringTasksByPartition(PARTITION0);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)1))).getRecurringTasksByPartition(PARTITION0);
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)2))).countRecurringTasksByPartition(PARTITION0);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)1))).getRecurringTasksByPartition(PARTITION0);
    }

    @Test
    void checkForRecurringTasksDoesNotScheduleSameTaskIfItIsAlreadyScheduledEnqueuedOrProcessed() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withCronExpression("*/5 * * * * *").build();
        Mockito.when((Object)this.storageProvider.countRecurringTasksByPartition(PARTITION0)).thenReturn((Object)1L);
        Mockito.when((Object)this.storageProvider.getRecurringTasksByPartition(PARTITION0)).thenReturn(List.of(recurringTask));
        Mockito.when((Object)this.storageProvider.recurringTaskExistsByPartition(recurringTask.getId(), PARTITION0, new StateName[]{StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING})).thenReturn((Object)true);
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.never())).saveByPartition(ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
    }

    @Test
    void checkForScheduledTasksEnqueuesTasksThatNeedToBeEnqueued() {
        Task scheduledTask = TaskTestBuilder.aScheduledTask().build();
        List<Task> tasks = List.of(scheduledTask);
        Mockito.when((Object)this.storageProvider.getScheduledTasksByPartition((Instant)ArgumentMatchers.any(), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(tasks, (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition((List)this.tasksToSaveArgumentCaptor.capture(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        CarrotAssertions.assertThat((Task)((List)this.tasksToSaveArgumentCaptor.getValue()).get(0)).hasStates(StateName.SCHEDULED, StateName.ENQUEUED);
    }

    @Test
    void checkForEnqueuedTasksIfTasksPresentSubmitsThemToTheBackgroundTaskServer() {
        Task enqueuedTask = TaskTestBuilder.anEnqueuedTask().build();
        List<Task> tasks = List.of(enqueuedTask);
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.emptyList());
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(tasks);
        this.taskZooKeeper.run();
        ((BackgroundTaskServer)Mockito.verify((Object)this.backgroundTaskServer)).processTask(enqueuedTask);
    }

    @Test
    void checkForEnqueuedTasksIsNotDoneConcurrently() throws InterruptedException {
        Mockito.when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenAnswer(invocationOnMock -> {
            SleepUtils.sleep(100L);
            return Collections.emptyList();
        });
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Thread thread1 = new Thread(() -> {
            this.taskZooKeeper.notifyThreadIdle();
            countDownLatch.countDown();
        });
        Thread thread2 = new Thread(() -> {
            this.taskZooKeeper.notifyThreadIdle();
            countDownLatch.countDown();
        });
        thread1.start();
        thread2.start();
        countDownLatch.await();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)1))).getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.ENQUEUED), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
    }

    @Test
    void checkForOrphanedTasks() {
        Task orphanedTask = TaskTestBuilder.anEnqueuedTask().withState((TaskState)new ProcessingState(this.backgroundTaskServer.getId())).build();
        Mockito.when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.PROCESSING), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(orphanedTask), (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition((List)this.tasksToSaveArgumentCaptor.capture(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        CarrotAssertions.assertThat((Task)((List)this.tasksToSaveArgumentCaptor.getValue()).get(0)).hasStates(StateName.ENQUEUED, StateName.PROCESSING, StateName.FAILED, StateName.SCHEDULED);
    }

    @Test
    void checkForSucceededTasksThanCanGoToDeletedState() {
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Arrays.asList(TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build()), (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).publishTotalAmountOfSucceededTasks(5);
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"SUCCEEDED->DELETED", "SUCCEEDED->DELETED", "SUCCEEDED->DELETED", "SUCCEEDED->DELETED", "SUCCEEDED->DELETED"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isFalse();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isFalse();
    }

    @Test
    void checkForSucceededTasksCanGoToDeletedStateAlsoWorksForInterfacesWithMethodsThatDontExistAnymore() {
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Arrays.asList(TaskTestBuilder.aSucceededTask().withTaskDetails(TaskDetailsTestBuilder.taskDetails().withClassName(TestServiceInterface.class).withMethodName("methodThatDoesNotExist").build()).build()), (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        CarrotAssertions.assertThat(this.logger).hasNoWarnLogMessages();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveByPartition(ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).publishTotalAmountOfSucceededTasks(1);
    }

    @Test
    void checkForTasksThatCanBeDeleted() {
        Mockito.when((Object)this.storageProvider.deleteTasksPermanentlyByPartition((StateName)ArgumentMatchers.eq((Object)StateName.DELETED), (Instant)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn((Object)5);
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).deleteTasksPermanentlyByPartition((StateName)ArgumentMatchers.eq((Object)StateName.DELETED), (Instant)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
    }

    @Test
    void allStateChangesArePassingViaTheApplyStateFilterOnSuccess() {
        Task task = TaskTestBuilder.aScheduledTask().build();
        Mockito.when((Object)this.storageProvider.getScheduledTasksByPartition((Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task), (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        CarrotAssertions.assertThat(this.logAllStateChangesFilter.stateChanges).containsExactly((Object[])new String[]{"SCHEDULED->ENQUEUED"});
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processingPassed).isFalse();
        CarrotAssertions.assertThat((boolean)this.logAllStateChangesFilter.processedPassed).isFalse();
    }

    @Test
    void taskNotFoundExceptionsDoNotCauseTheBackgroundTaskServerToStop() {
        Task task = TaskTestBuilder.aSucceededTask().withTaskDetails(TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails()).build();
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Collections.singletonList(task), (Object[])this.emptyTaskList());
        this.taskZooKeeper.run();
        AtomicInteger exceptionCount = (AtomicInteger)Whitebox.getInternalState(this.taskZooKeeper, "exceptionCount");
        CarrotAssertions.assertThat((AtomicInteger)exceptionCount).hasValue(0);
        CarrotAssertions.assertThat(this.logger).hasNoWarnLogMessages();
    }

    @Test
    void severeCarrotExceptionsAreLoggedToStorageProvider() {
        Task succeededTask1 = TaskTestBuilder.aSucceededTask().build();
        Task succeededTask2 = TaskTestBuilder.aSucceededTask().build();
        Mockito.when((Object)this.storageProvider.getTaskById(succeededTask1.getId())).thenReturn((Object)succeededTask1);
        Mockito.when((Object)this.storageProvider.getTaskById(succeededTask2.getId())).thenReturn((Object)succeededTask2);
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Arrays.asList(succeededTask1, succeededTask2, TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build()), (Object[])this.emptyTaskList());
        Mockito.when((Object)this.storageProvider.saveByPartition(ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenThrow(new Throwable[]{new ConcurrentTaskModificationException(Arrays.asList(succeededTask1, succeededTask2))});
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).saveMetadata((CarrotMetadata)this.carrotMetadataArgumentCaptor.capture());
        CarrotAssertions.assertThat((CarrotMetadata)this.carrotMetadataArgumentCaptor.getValue()).hasName(SevereCarrotException.class.getSimpleName()).hasOwner("BackgroundTaskServer " + this.backgroundTaskServer.getId()).valueContains("## Runtime information");
    }

    @Test
    void taskZooKeeperStopsIfTooManyExceptions() {
        Task succeededTask1 = TaskTestBuilder.aSucceededTask().build();
        Task succeededTask2 = TaskTestBuilder.aSucceededTask().build();
        Mockito.when((Object)this.storageProvider.getTaskById(succeededTask1.getId())).thenReturn((Object)succeededTask1);
        Mockito.when((Object)this.storageProvider.getTaskById(succeededTask2.getId())).thenReturn((Object)succeededTask2);
        Mockito.lenient().when((Object)this.storageProvider.getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenReturn(Arrays.asList(succeededTask1, succeededTask2, TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build(), TaskTestBuilder.aSucceededTask().build()));
        Mockito.when((Object)this.storageProvider.saveByPartition(ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.eq((Object)PARTITION0))).thenThrow(new Throwable[]{new ConcurrentTaskModificationException(Arrays.asList(succeededTask1, succeededTask2))});
        for (int i = 0; i <= 5; ++i) {
            this.taskZooKeeper.run();
        }
        AtomicInteger exceptionCount = (AtomicInteger)Whitebox.getInternalState(this.taskZooKeeper, "exceptionCount");
        CarrotAssertions.assertThat((AtomicInteger)exceptionCount).hasValue(6);
    }

    @Test
    void masterTasksArePostponedToNextRunIfPollIntervalInSecondsTimeboxIsAboutToPass() {
        Mockito.when((Object)this.backgroundTaskServer.isUnAnnounced()).then(this.putRunStartTimeInPast());
        this.taskZooKeeper.run();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.never())).getScheduledTasksByPartition((Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(PageRequest.class), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.never())).getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.PROCESSING), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(PageRequest.class), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.never())).getTasksByPartition((StateName)ArgumentMatchers.eq((Object)StateName.SUCCEEDED), (Instant)ArgumentMatchers.any(Instant.class), (PageRequest)ArgumentMatchers.any(PageRequest.class), (Integer)ArgumentMatchers.eq((Object)PARTITION0));
    }

    private TaskZooKeeper initializeTaskZooKeeper() {
        UUID backgroundTaskServerId = UUID.randomUUID();
        Mockito.lenient().when((Object)this.backgroundTaskServer.getId()).thenReturn((Object)backgroundTaskServerId);
        Mockito.when((Object)this.backgroundTaskServer.getStorageProvider()).thenReturn((Object)this.storageProvider);
        Mockito.when((Object)this.backgroundTaskServer.getServerStatus()).thenReturn((Object)this.backgroundTaskServerStatus);
        Mockito.when((Object)this.backgroundTaskServer.getWorkDistributionStrategy()).thenReturn((Object)this.workDistributionStrategy);
        Mockito.when((Object)this.backgroundTaskServer.getTaskFilters()).thenReturn((Object)new TaskDefaultFilters(new TaskFilter[]{this.logAllStateChangesFilter}));
        Mockito.when((Object)this.backgroundTaskServer.getDashboardNotificationManager()).thenReturn((Object)new DashboardNotificationManager(backgroundTaskServerId, this.storageProvider));
        Mockito.lenient().when((Object)this.workDistributionStrategy.canOnboardNewWork()).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.workDistributionStrategy.getWorkPageRequest()).thenReturn((Object)PageRequest.ascOnUpdatedAt((int)10));
        Mockito.lenient().when((Object)this.backgroundTaskServer.isAnnounced()).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.backgroundTaskServer.getPartition()).thenReturn((Object)PARTITION0);
        return new TaskZooKeeper(this.backgroundTaskServer);
    }

    private List<Task>[] emptyTaskList() {
        List[] result = (List[])ReflectionUtils.cast((Object)new ArrayList[1]);
        result[0] = new ArrayList();
        return result;
    }

    private Answer<Boolean> putRunStartTimeInPast() {
        return invocation -> {
            Whitebox.setInternalState(this.taskZooKeeper, "runStartTime", Instant.ofEpochMilli(System.currentTimeMillis() - 15000L));
            return false;
        };
    }
}

