/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.DefaultConcurrentTaskModificationResolver;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.StateName;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class DefaultConcurrentTaskModificationResolverTest {
    private DefaultConcurrentTaskModificationResolver concurrentTaskModificationResolver;
    @Mock
    private PartitionedStorageProvider storageProvider;
    @Mock
    private TaskZooKeeper taskZooKeeper;

    @BeforeEach
    void setUp() {
        this.concurrentTaskModificationResolver = new DefaultConcurrentTaskModificationResolver(this.storageProvider, this.taskZooKeeper);
    }

    @ParameterizedTest
    @MethodSource(value={"getTasksInDifferentStates"})
    void concurrentStateChangeFromSucceededFailedOrScheduledToDeletedIsAllowed(Task localTask, Task storageProviderTask) {
        Thread taskThread = (Thread)Mockito.mock(Thread.class);
        Mockito.when((Object)this.storageProvider.getTaskById(localTask.getId())).thenReturn((Object)storageProviderTask);
        Mockito.lenient().when((Object)this.taskZooKeeper.getThreadProcessingTask(localTask)).thenReturn((Object)taskThread);
        this.concurrentTaskModificationResolver.resolve(new ConcurrentTaskModificationException(localTask));
        Mockito.verifyNoInteractions((Object[])new Object[]{taskThread});
    }

    @Test
    void concurrentStateChangeFromProcessingToDeletedIsAllowedAndInterruptsThread() {
        Task task1 = TaskTestBuilder.aTaskInProgress().build();
        Task task2 = TaskTestBuilder.aTaskInProgress().build();
        Thread task1Thread = (Thread)Mockito.mock(Thread.class);
        Thread task2Thread = (Thread)Mockito.mock(Thread.class);
        Mockito.when((Object)this.storageProvider.getTaskById(task1.getId())).thenReturn((Object)TaskTestBuilder.aCopyOf(task1).withDeletedState().build());
        Mockito.when((Object)this.storageProvider.getTaskById(task2.getId())).thenReturn((Object)TaskTestBuilder.aCopyOf(task2).withDeletedState().build());
        Mockito.when((Object)this.taskZooKeeper.getThreadProcessingTask(task1)).thenReturn((Object)task1Thread);
        Mockito.when((Object)this.taskZooKeeper.getThreadProcessingTask(task2)).thenReturn((Object)task2Thread);
        this.concurrentTaskModificationResolver.resolve(new ConcurrentTaskModificationException(Arrays.asList(task1, task2)));
        ((Thread)Mockito.verify((Object)task1Thread)).interrupt();
        ((Thread)Mockito.verify((Object)task2Thread)).interrupt();
        CarrotAssertions.assertThat(task1).hasState(StateName.DELETED);
        CarrotAssertions.assertThat(task2).hasState(StateName.DELETED);
    }

    @Test
    void concurrentStateChangeFromUnsupportedStateChangeIsNotAllowedAndThrowsException() {
        Task task1 = TaskTestBuilder.aTaskInProgress().build();
        Task task2 = TaskTestBuilder.aTaskInProgress().build();
        Mockito.when((Object)this.storageProvider.getTaskById(task1.getId())).thenReturn((Object)TaskTestBuilder.aCopyOf(task1).build());
        Mockito.when((Object)this.storageProvider.getTaskById(task2.getId())).thenReturn((Object)TaskTestBuilder.aCopyOf(task2).build());
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.concurrentTaskModificationResolver.resolve(new ConcurrentTaskModificationException(Arrays.asList(task1, task2)))).isInstanceOf(ConcurrentTaskModificationException.class)).has(CarrotAssertions.failedTask(task1))).has(CarrotAssertions.failedTask(task2));
    }

    static Stream<Arguments> getTasksInDifferentStates() {
        Task scheduledTask = TaskTestBuilder.aScheduledTask().build();
        Task taskInProgress = TaskTestBuilder.aTaskInProgress().build();
        return Stream.of(Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}));
    }
}

