/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.server.concurrent.UnresolvableConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.Task;
import java.util.Collections;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnresolvableConcurrentTaskModificationExceptionTest {
    @Test
    void canGenerateCorrectDiagnosticsInfo() {
        Task localTask = TaskTestBuilder.aSucceededTask().build();
        Task taskFromStorage = TaskTestBuilder.aFailedTask().build();
        ConcurrentTaskModificationResolveResult resolveResult = ConcurrentTaskModificationResolveResult.failed((Task)localTask, (Task)taskFromStorage);
        UnresolvableConcurrentTaskModificationException unresolvableConcurrentTaskModificationException = new UnresolvableConcurrentTaskModificationException(Collections.singletonList(resolveResult));
        String markDown = unresolvableConcurrentTaskModificationException.getDiagnosticsInfo().asMarkDown();
        ((AbstractStringAssert)Assertions.assertThat((String)markDown).containsPattern((CharSequence)"SUCCEEDED (.*) \u2190 PROCESSING (.*) \u2190 ENQUEUED")).containsPattern((CharSequence)"FAILED (.*) \u2190 PROCESSING (.*) \u2190 ENQUEUED");
    }

    @Test
    void canGenerateCorrectDiagnosticsInfoEvenWithOnly1State() {
        Task localTask = TaskTestBuilder.anEnqueuedTask().build();
        Task taskFromStorage = TaskTestBuilder.aFailedTask().build();
        ConcurrentTaskModificationResolveResult resolveResult = ConcurrentTaskModificationResolveResult.failed((Task)localTask, (Task)taskFromStorage);
        UnresolvableConcurrentTaskModificationException unresolvableConcurrentTaskModificationException = new UnresolvableConcurrentTaskModificationException(Collections.singletonList(resolveResult));
        String markDown = unresolvableConcurrentTaskModificationException.getDiagnosticsInfo().asMarkDown();
        ((AbstractStringAssert)Assertions.assertThat((String)markDown).containsPattern((CharSequence)"ENQUEUED")).containsPattern((CharSequence)"FAILED (.*) \u2190 PROCESSING (.*) \u2190 ENQUEUED");
    }
}

