/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.UseStorageProviderTaskConcurrentTaskModificationResolver;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.StateName;
import java.time.Instant;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class UseStorageProviderTaskConcurrentTaskModificationResolverTest {
    private UseStorageProviderTaskConcurrentTaskModificationResolver concurrentTaskModificationResolver;
    @Mock
    private TaskZooKeeper taskZooKeeper;

    @BeforeEach
    void setUp() {
        this.concurrentTaskModificationResolver = new UseStorageProviderTaskConcurrentTaskModificationResolver(this.taskZooKeeper);
    }

    @ParameterizedTest
    @MethodSource(value={"getTasksInDifferentStates"})
    void concurrentStateChangeFromSucceededFailedOrScheduledToDeletedIsAllowed(Task localTask, Task storageProviderTask) {
        Thread taskThread = (Thread)Mockito.mock(Thread.class);
        Mockito.lenient().when((Object)this.taskZooKeeper.getThreadProcessingTask(localTask)).thenReturn((Object)taskThread);
        this.concurrentTaskModificationResolver.resolve(new ConcurrentTaskModificationException(localTask));
        ((Thread)Mockito.verify((Object)taskThread)).interrupt();
        CarrotAssertions.assertThat(localTask).hasOneOfTheFollowingStates(StateName.FAILED, StateName.SUCCEEDED);
    }

    static Stream<Arguments> getTasksInDifferentStates() {
        Task scheduledTask = TaskTestBuilder.aScheduledTask().build();
        Task taskInProgress = TaskTestBuilder.aTaskInProgress().build();
        return Stream.of(Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withScheduledState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withProcessingState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withProcessingState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withProcessingState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withProcessingState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withFailedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(scheduledTask).withEnqueuedState(Instant.now()).build(), TaskTestBuilder.aCopyOf(scheduledTask).withSucceededState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withFailedState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build()}), Arguments.arguments((Object[])new Object[]{TaskTestBuilder.aCopyOf(taskInProgress).withScheduledState().build(), TaskTestBuilder.aCopyOf(taskInProgress).withSucceededState().build()}));
    }
}

