/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent.statechanges;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileProcessingConcurrentStateChange;
import cn.boboweike.carrot.tasks.Task;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class DeletedWhileProcessingConcurrentStateChangeTest {
    DeletedWhileProcessingConcurrentStateChange allowedStateChange;
    @Mock
    private TaskZooKeeper taskZooKeeper;

    @BeforeEach
    public void setUp() {
        this.allowedStateChange = new DeletedWhileProcessingConcurrentStateChange(this.taskZooKeeper);
    }

    @Test
    void ifTaskDeletedWhileGoingToProcessing() {
        Task taskInProgress = TaskTestBuilder.aTaskInProgress().build();
        Task taskInProgressWithUpdate = TaskTestBuilder.aCopyOf(taskInProgress).withMetadata("extra", "metadata").build();
        Task deletedTask = TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build();
        Thread mockThread = (Thread)Mockito.mock(Thread.class);
        Mockito.when((Object)this.taskZooKeeper.getThreadProcessingTask(taskInProgressWithUpdate)).thenReturn((Object)mockThread);
        ConcurrentTaskModificationResolveResult resolveResult = this.allowedStateChange.resolve(taskInProgressWithUpdate, deletedTask);
        Assertions.assertThat((boolean)resolveResult.failed()).isFalse();
        ((Thread)Mockito.verify((Object)mockThread)).interrupt();
    }

    @Test
    void ifTaskDeletedWhileGoingToProcessingButThreadIsAlreadyRemoved() {
        Task taskInProgress = TaskTestBuilder.aTaskInProgress().build();
        Task taskInProgressWithUpdate = TaskTestBuilder.aCopyOf(taskInProgress).withMetadata("extra", "metadata").build();
        Task deletedTask = TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build();
        ConcurrentTaskModificationResolveResult resolveResult = this.allowedStateChange.resolve(taskInProgressWithUpdate, deletedTask);
        Assertions.assertThat((boolean)resolveResult.failed()).isFalse();
    }
}

