/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent.statechanges;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileSucceededConcurrentStateChange;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.SucceededState;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeletedWhileSucceedConcurrentStateChangeTest {
    DeletedWhileSucceededConcurrentStateChange allowedStateChange;

    @BeforeEach
    public void setUp() {
        this.allowedStateChange = new DeletedWhileSucceededConcurrentStateChange();
    }

    @Test
    void ifTaskDeletedWhileGoingToSucceededStateThereIsNoInterruptNeeded() {
        Task taskInProgress = TaskTestBuilder.aTaskInProgress().build();
        Task succeededTask = TaskTestBuilder.aCopyOf(taskInProgress).withState((TaskState)new SucceededState(Duration.ofMillis(10L), Duration.ofMillis(6L))).build();
        Task deletedTask = TaskTestBuilder.aCopyOf(taskInProgress).withDeletedState().build();
        ConcurrentTaskModificationResolveResult resolveResult = this.allowedStateChange.resolve(succeededTask, deletedTask);
        Assertions.assertThat((boolean)resolveResult.failed()).isFalse();
    }
}

