/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.dashboard;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.server.dashboard.DashboardNotification;
import cn.boboweike.carrot.server.dashboard.DashboardNotificationManager;
import cn.boboweike.carrot.server.dashboard.NewCarrotVersionNotification;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.utils.diagnostics.DiagnosticsBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class DashboardNotificationManagerTest {
    private UUID backgroundTaskServerId;
    @Mock
    private PartitionedStorageProvider storageProviderMock;
    @Captor
    private ArgumentCaptor<CarrotMetadata> carrotMetadataToSaveArgumentCaptor;
    private DashboardNotificationManager dashboardNotificationManager;

    @BeforeEach
    void setUp() {
        this.backgroundTaskServerId = UUID.randomUUID();
        this.dashboardNotificationManager = new DashboardNotificationManager(this.backgroundTaskServerId, this.storageProviderMock);
    }

    @Test
    void handleSupportsSevereCarrotExceptionAndShouldSaveCarrotMetadataToStorageProvider() {
        this.dashboardNotificationManager.handle((Exception)new SevereCarrotException("Severe exception occurred", (SevereCarrotException.DiagnosticsAware)new SomeException()));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProviderMock)).saveMetadata((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.capture());
        CarrotAssertions.assertThat((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.getValue()).hasName(SevereCarrotException.class.getSimpleName()).hasOwner("BackgroundTaskServer " + this.backgroundTaskServerId.toString()).valueContains("Runtime information").valueContains("Timestamp").valueContains("Carrot Version").valueContains("__StorageProvider__: " + this.storageProviderMock.getClass().getName()).valueContains("Background Task Servers").valueContains("## Diagnostics from exception").valueContains("### Title from inner exception").valueContains("#### Title from inner exception").valueContains("Line from inner exception");
    }

    @Test
    void notifyForCpuAllocationIrregularityShouldSaveCarrotMetadataToStorageProvider() {
        this.dashboardNotificationManager.notify((DashboardNotification)new CpuAllocationIrregularityNotification(Integer.valueOf(11)));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProviderMock)).saveMetadata((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.capture());
        CarrotAssertions.assertThat((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.getValue()).hasName(CpuAllocationIrregularityNotification.class.getSimpleName()).hasOwner("BackgroundTaskServer " + this.backgroundTaskServerId.toString()).valueContains("11");
    }

    @Test
    void notifyForNewCarrotVersionShouldSaveCarrotMetadataToStorageProvider() {
        this.dashboardNotificationManager.notify((DashboardNotification)new NewCarrotVersionNotification("4.0.0"));
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProviderMock)).saveMetadata((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.capture());
        CarrotAssertions.assertThat((CarrotMetadata)this.carrotMetadataToSaveArgumentCaptor.getValue()).hasName(NewCarrotVersionNotification.class.getSimpleName()).hasOwner("cluster").valueContains("4.0.0");
    }

    @Test
    void notificationsCanBeRetrievedReturnsNullIfNoneAvailable() {
        Mockito.when((Object)this.storageProviderMock.getMetadata(NewCarrotVersionNotification.class.getSimpleName())).thenReturn(Collections.emptyList());
        NewCarrotVersionNotification dashboardNotification = (NewCarrotVersionNotification)this.dashboardNotificationManager.getDashboardNotification(NewCarrotVersionNotification.class);
        CarrotAssertions.assertThat((Object)dashboardNotification).isNull();
    }

    @Test
    void notificationsCanBeRetrievedIfAvailable() {
        Mockito.when((Object)this.storageProviderMock.getMetadata(NewCarrotVersionNotification.class.getSimpleName())).thenReturn(Arrays.asList(new CarrotMetadata(NewCarrotVersionNotification.class.getSimpleName(), "cluster", "4.0.0")));
        NewCarrotVersionNotification dashboardNotification = (NewCarrotVersionNotification)this.dashboardNotificationManager.getDashboardNotification(NewCarrotVersionNotification.class);
        CarrotAssertions.assertThat((String)dashboardNotification.getLatestVersion()).isEqualTo("4.0.0");
    }

    private static class SomeException
    extends Exception
    implements SevereCarrotException.DiagnosticsAware {
        private SomeException() {
        }

        public DiagnosticsBuilder getDiagnosticsInfo() {
            return DiagnosticsBuilder.diagnostics().withTitle("Title from inner exception").withTitle("Subtitle from inner exception").withLine("Line from inner exception");
        }
    }
}

