/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.jmx;

import cn.boboweike.carrot.server.jmx.TaskServerStats;
import java.lang.management.OperatingSystemMXBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TaskServerStatsTest {
    private ObjectName objectName;
    @Mock
    private OperatingSystemMXBean operatingSystemMXBean;
    @Mock
    private MBeanServer mBeanServer;
    private TaskServerStats taskServerStats;

    @BeforeEach
    void setUp() throws MalformedObjectNameException {
        this.objectName = new ObjectName("java.lang:type=OperatingSystem");
        Mockito.when((Object)this.operatingSystemMXBean.getObjectName()).thenReturn((Object)this.objectName);
        this.taskServerStats = new TaskServerStats(this.operatingSystemMXBean, this.mBeanServer);
    }

    @Test
    void ifOperatingSystemMXBeanReturnsNaNForSystemCpuLoadOnFirstCall_NegativeIsReturned() throws JMException {
        Mockito.when((Object)this.mBeanServer.getAttribute(this.objectName, "SystemCpuLoad")).thenReturn((Object)Double.NaN);
        Assertions.assertThat((Double)this.taskServerStats.getSystemCpuLoad()).isEqualTo(-1.0);
    }

    @Test
    void ifOperatingSystemMXBeanReturnsNaNForSystemCpuLoadOnLaterCalls_CachedValueIsReturned() throws JMException {
        Mockito.when((Object)this.mBeanServer.getAttribute(this.objectName, "SystemCpuLoad")).thenReturn((Object)0.7, new Object[]{Double.NaN, 0.5});
        Assertions.assertThat((Double)this.taskServerStats.getSystemCpuLoad()).isEqualTo(0.7);
        Assertions.assertThat((Double)this.taskServerStats.getSystemCpuLoad()).isEqualTo(0.7);
        Assertions.assertThat((Double)this.taskServerStats.getSystemCpuLoad()).isEqualTo(0.5);
    }

    @Test
    void ifOperatingSystemMXBeanReturnsNaNForProcessCpuLoadOnFirstCall_NegativeIsReturned() throws JMException {
        Mockito.when((Object)this.mBeanServer.getAttribute(this.objectName, "ProcessCpuLoad")).thenReturn((Object)Double.NaN);
        Assertions.assertThat((Double)this.taskServerStats.getProcessCpuLoad()).isEqualTo(-1.0);
    }

    @Test
    void ifOperatingSystemMXBeanReturnsNaNForProcessCpuLoadOnLaterCalls_CachedValueIsReturned() throws JMException {
        Mockito.when((Object)this.mBeanServer.getAttribute(this.objectName, "ProcessCpuLoad")).thenReturn((Object)0.7, new Object[]{Double.NaN, 0.5});
        Assertions.assertThat((Double)this.taskServerStats.getProcessCpuLoad()).isEqualTo(0.7);
        Assertions.assertThat((Double)this.taskServerStats.getProcessCpuLoad()).isEqualTo(0.7);
        Assertions.assertThat((Double)this.taskServerStats.getProcessCpuLoad()).isEqualTo(0.5);
    }
}

