/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.runner.AbstractBackgroundTaskRunner;
import cn.boboweike.carrot.server.runner.ThreadLocalTaskContext;
import cn.boboweike.carrot.tasks.Task;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class AbstractBackgroundTaskRunnerTest {
    @Mock
    private AbstractBackgroundTaskRunner.BackgroundTaskWorker worker;

    @Test
    void ifCodeThrowsInterruptedException_AnInterruptExceptionIsThrown() throws Exception {
        AbstractBackgroundTaskRunner backgroundTaskRunner = this.getTaskRunner();
        Task task = TaskTestBuilder.aTaskInProgress().build();
        ((AbstractBackgroundTaskRunner.BackgroundTaskWorker)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedException()}).when((Object)this.worker)).run();
        Assertions.assertThatThrownBy(() -> backgroundTaskRunner.run(task)).isInstanceOf(InterruptedException.class);
    }

    @Test
    void ifCurrentThreadIsInterrupted_AnInterruptExceptionIsThrown() throws Exception {
        AbstractBackgroundTaskRunner backgroundTaskRunner = this.getTaskRunner();
        Task task = TaskTestBuilder.aTaskInProgress().build();
        ((AbstractBackgroundTaskRunner.BackgroundTaskWorker)Mockito.doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            return null;
        }).when((Object)this.worker)).run();
        Assertions.assertThatThrownBy(() -> backgroundTaskRunner.run(task)).isInstanceOf(InterruptedException.class);
    }

    @Test
    void invokeTaskMethodUpdatesTaskContextThreadLocal() throws Exception {
        Task task = TaskTestBuilder.aTaskInProgress().withTaskDetails(this::testTaskContext).build();
        AbstractBackgroundTaskRunner backgroundTaskRunner = this.getTaskRunner(AbstractBackgroundTaskRunner.BackgroundTaskWorker::new);
        backgroundTaskRunner.run(task);
        Assertions.assertThat((Object)ThreadLocalTaskContext.getTaskContext()).isNull();
    }

    @Test
    void invokeTaskMethodAlwaysResetsTaskContextThreadLocal() {
        Task task = TaskTestBuilder.aTaskInProgress().withTaskDetails(this::throwingTaskContext).build();
        AbstractBackgroundTaskRunner backgroundTaskRunner = this.getTaskRunner(AbstractBackgroundTaskRunner.BackgroundTaskWorker::new);
        Assertions.assertThatCode(() -> backgroundTaskRunner.run(task)).isInstanceOf(Exception.class);
        Assertions.assertThat((Object)ThreadLocalTaskContext.getTaskContext()).isNull();
    }

    private AbstractBackgroundTaskRunner getTaskRunner() {
        return this.getTaskRunner(task -> this.worker);
    }

    private AbstractBackgroundTaskRunner getTaskRunner(final Function<Task, AbstractBackgroundTaskRunner.BackgroundTaskWorker> worker) {
        return new AbstractBackgroundTaskRunner(){

            public boolean supports(Task task) {
                return true;
            }

            protected AbstractBackgroundTaskRunner.BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
                return (AbstractBackgroundTaskRunner.BackgroundTaskWorker)worker.apply(task);
            }
        };
    }

    public void testTaskContext() {
        Assertions.assertThat((Object)ThreadLocalTaskContext.getTaskContext()).isNotNull();
    }

    public void throwingTaskContext() {
        Assertions.assertThat((Object)ThreadLocalTaskContext.getTaskContext()).isNotNull();
        throw new RuntimeException("Boem");
    }
}

