/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.runner.BackgroundStaticFieldTaskWithoutIocRunner;
import cn.boboweike.carrot.tasks.Task;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackgroundStaticFieldTaskWithoutIocRunnerTest {
    private BackgroundStaticFieldTaskWithoutIocRunner backgroundStaticFieldTaskWithoutIocRunner;

    @BeforeEach
    void setup() {
        this.backgroundStaticFieldTaskWithoutIocRunner = new BackgroundStaticFieldTaskWithoutIocRunner();
    }

    @Test
    void supportsTaskIfTaskIsStaticMethodCall() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("This is a test")).build();
        Assertions.assertThat((boolean)this.backgroundStaticFieldTaskWithoutIocRunner.supports(task)).isTrue();
    }

    @Test
    void doesNotSupportTaskIfTaskIsNotAStaticMethodCall() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThat((boolean)this.backgroundStaticFieldTaskWithoutIocRunner.supports(task)).isFalse();
    }

    @Test
    void runSimpleMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("This is a test")).build();
        Assertions.assertThatCode(() -> this.backgroundStaticFieldTaskWithoutIocRunner.run(task)).doesNotThrowAnyException();
    }
}

