/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.fixtures.stubs.StaticTestService;
import cn.boboweike.carrot.fixtures.stubs.TestServiceForIoC;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.runner.BackgroundStaticTaskWithoutIocRunner;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackgroundStaticTaskWithoutIocRunnerTest {
    private BackgroundStaticTaskWithoutIocRunner backgroundStaticTaskWithoutIocRunner;

    @BeforeEach
    void setup() {
        this.backgroundStaticTaskWithoutIocRunner = new BackgroundStaticTaskWithoutIocRunner();
    }

    @Test
    void doesNotSupportTaskIfTaskMethodIsNotStatic() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((IocTaskLambda & Serializable)ts -> ts.doWorkThatFails()).build();
        Assertions.assertThat((boolean)this.backgroundStaticTaskWithoutIocRunner.supports(task)).isFalse();
    }

    @Test
    void doesNotSupportTaskIfTaskHasStaticField() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("This is a test")).build();
        Assertions.assertThat((boolean)this.backgroundStaticTaskWithoutIocRunner.supports(task)).isFalse();
    }

    @Test
    void supportsTaskIfTaskClassHasPrivateConstructorButStaticTaskMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> TestServiceForIoC.doWorkInStaticMethod(UUID.randomUUID())).build();
        Assertions.assertThat((boolean)this.backgroundStaticTaskWithoutIocRunner.supports(task)).isTrue();
    }

    @Test
    void runSimpleMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> StaticTestService.doWorkInStaticMethod(UUID.randomUUID())).build();
        Assertions.assertThatCode(() -> this.backgroundStaticTaskWithoutIocRunner.run(task)).doesNotThrowAnyException();
    }

    @Test
    void runMethodWithTaskContext() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails((TaskLambda & Serializable)() -> StaticTestService.doWorkInStaticMethod(UUID.randomUUID(), TaskContext.Null)).build();
        Assertions.assertThatCode(() -> this.backgroundStaticTaskWithoutIocRunner.run(task)).doesNotThrowAnyException();
    }
}

