/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.stubs.TestServiceForIoC;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.stubs.SimpleTaskActivator;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.server.runner.BackgroundTaskWithIocRunner;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskParameter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackgroundTaskWithIocRunnerTest {
    private BackgroundTaskWithIocRunner backgroundIoCTaskWithIocRunner;

    @BeforeEach
    void setup() {
        this.backgroundIoCTaskWithIocRunner = new BackgroundTaskWithIocRunner((TaskActivator)new SimpleTaskActivator(new TestService()));
    }

    @Test
    void supportsTaskIfTaskClassIsKnownInIoC() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThat((boolean)this.backgroundIoCTaskWithIocRunner.supports(task)).isTrue();
    }

    @Test
    void doesNotSupportTaskIfNoTaskActivatorIsRegistered() {
        this.backgroundIoCTaskWithIocRunner = new BackgroundTaskWithIocRunner(null);
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThat((boolean)this.backgroundIoCTaskWithIocRunner.supports(task)).isFalse();
    }

    @Test
    void doesNotSupportTaskIfTaskClassIsNotKnownInIoC() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails().withClassName(TestServiceForIoC.class)).build();
        Assertions.assertThat((boolean)this.backgroundIoCTaskWithIocRunner.supports(task)).isFalse();
    }

    @Test
    void runSimpleMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThatCode(() -> this.backgroundIoCTaskWithIocRunner.run(task)).doesNotThrowAnyException();
    }

    @Test
    void runMethodWithTaskContext() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails().withTaskParameter(TaskParameter.TaskContext)).build();
        Assertions.assertThatCode(() -> this.backgroundIoCTaskWithIocRunner.run(task)).doesNotThrowAnyException();
    }
}

