/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.fixtures.stubs.TestServiceForIoC;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.runner.BackgroundTaskWithoutIocRunner;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskParameter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackgroundTaskWithoutIocRunnerTest {
    private BackgroundTaskWithoutIocRunner backgroundTaskWithoutIocRunner;

    @BeforeEach
    void setup() {
        this.backgroundTaskWithoutIocRunner = new BackgroundTaskWithoutIocRunner();
    }

    @Test
    void supportsTaskIfTaskClassHasDefaultConstructor() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThat((boolean)this.backgroundTaskWithoutIocRunner.supports(task)).isTrue();
    }

    @Test
    void doesNotSupportTaskIfClassHasNoDefaultConstructor() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails().withClassName(TestServiceForIoC.class)).build();
        Assertions.assertThat((boolean)this.backgroundTaskWithoutIocRunner.supports(task)).isFalse();
    }

    @Test
    void runSimpleMethod() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails()).build();
        Assertions.assertThatCode(() -> this.backgroundTaskWithoutIocRunner.run(task)).doesNotThrowAnyException();
    }

    @Test
    void runMethodWithTaskContext() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.defaultTaskDetails().withTaskParameter(TaskParameter.TaskContext)).build();
        Assertions.assertThatCode(() -> this.backgroundTaskWithoutIocRunner.run(task)).doesNotThrowAnyException();
    }
}

