/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.strategy;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.strategy.BasicWorkDistributionStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BasicWorkDistributionStrategyTest {
    @Mock
    private BackgroundTaskServer backgroundTaskServer;
    @Mock
    private TaskZooKeeper taskZooKeeper;
    private BasicWorkDistributionStrategy workDistributionStrategy;

    @BeforeEach
    void setUpWorkDistributionStrategy() {
        Mockito.when((Object)this.backgroundTaskServer.getTaskZooKeeper()).thenReturn((Object)this.taskZooKeeper);
        this.workDistributionStrategy = new BasicWorkDistributionStrategy(this.backgroundTaskServer, 100);
    }

    @Test
    void canOnboardIfWorkQueueSizeIsEmpty() {
        Mockito.when((Object)this.taskZooKeeper.getOccupiedWorkerCount()).thenReturn((Object)0);
        Assertions.assertThat((boolean)this.workDistributionStrategy.canOnboardNewWork()).isTrue();
    }

    @Test
    void canNotOnboardIfWorkQueueIsFull() {
        Mockito.when((Object)this.taskZooKeeper.getOccupiedWorkerCount()).thenReturn((Object)100);
        Assertions.assertThat((boolean)this.workDistributionStrategy.canOnboardNewWork()).isFalse();
    }

    @Test
    void canOnboardIfMoreThan30PercentFreeInWorkQueue() {
        Mockito.when((Object)this.taskZooKeeper.getOccupiedWorkerCount()).thenReturn((Object)69);
        Assertions.assertThat((boolean)this.workDistributionStrategy.canOnboardNewWork()).isTrue();
    }

    @Test
    void canNotOnboardIfLessThan30PercentFreeInWorkQueue() {
        Mockito.when((Object)this.taskZooKeeper.getOccupiedWorkerCount()).thenReturn((Object)71);
        Assertions.assertThat((boolean)this.workDistributionStrategy.canOnboardNewWork()).isFalse();
    }
}

