/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.tasks;

import ch.qos.logback.LoggerAssert;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.server.tasks.CheckIfAllTasksExistTask;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.TaskUtils;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CheckIfAllTasksExistTaskTest {
    private CheckIfAllTasksExistTask checkIfAllTasksExistTask;
    @Mock
    private BackgroundTaskServer backgroundTaskServer;
    @Mock
    private PartitionedStorageProvider storageProvider;
    private ListAppender<ILoggingEvent> logger;

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.backgroundTaskServer.getStorageProvider()).thenReturn((Object)this.storageProvider);
        this.checkIfAllTasksExistTask = new CheckIfAllTasksExistTask(this.backgroundTaskServer);
        this.logger = LoggerAssert.initFor(this.checkIfAllTasksExistTask);
    }

    @Test
    void onRunItLogsAllRecurringTasksThatDoNotExist() {
        Mockito.when((Object)this.storageProvider.getRecurringTasks()).thenReturn(Arrays.asList(RecurringTaskTestBuilder.aDefaultRecurringTask().build(), RecurringTaskTestBuilder.aDefaultRecurringTask().withTaskDetails(TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails()).build()));
        this.checkIfAllTasksExistTask.run();
        CarrotAssertions.assertThat(this.logger).hasWarningMessageContaining("Carrot found RECURRING tasks that do not exist anymore").hasWarningMessageContaining("i.dont.exist.Class.notImportant(java.lang.Integer)").hasNoErrorLogMessages();
    }

    @Test
    void onRunItLogsAllScheduledTasksThatDoNotExist() {
        Mockito.when((Object)this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.SCHEDULED})).thenReturn(Set.of(TaskUtils.getTaskSignature((TaskDetails)TaskDetailsTestBuilder.defaultTaskDetails().build()), TaskUtils.getTaskSignature((TaskDetails)TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails().build())));
        this.checkIfAllTasksExistTask.run();
        CarrotAssertions.assertThat(this.logger).hasWarningMessageContaining("Carrot found SCHEDULED tasks that do not exist anymore").hasWarningMessageContaining("i.dont.exist.Class.notImportant(java.lang.Integer)").hasNoErrorLogMessages();
    }

    @Test
    void onRunItLogsAllScheduledAndRecurringTasksThatDoNotExist() {
        Mockito.when((Object)this.storageProvider.getRecurringTasks()).thenReturn(Arrays.asList(RecurringTaskTestBuilder.aDefaultRecurringTask().build(), RecurringTaskTestBuilder.aDefaultRecurringTask().withTaskDetails(TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails()).build()));
        Mockito.when((Object)this.storageProvider.getDistinctTaskSignatures(new StateName[]{StateName.SCHEDULED})).thenReturn(Set.of(TaskUtils.getTaskSignature((TaskDetails)TaskDetailsTestBuilder.defaultTaskDetails().build()), TaskUtils.getTaskSignature((TaskDetails)TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails().build())));
        this.checkIfAllTasksExistTask.run();
        CarrotAssertions.assertThat(this.logger).hasWarningMessageContaining("Carrot found RECURRING AND SCHEDULED tasks that do not exist anymore in your code.").hasWarningMessageContaining("i.dont.exist.Class.notImportant(java.lang.Integer)").hasWarningMessageContaining("cn.boboweike.carrot.fixtures.stubs.TestService.doWorkThatDoesNotExist(java.lang.Integer)").hasNoErrorLogMessages();
    }
}

