/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.BackgroundTaskServerStatusChangeListener;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.storage.listeners.TaskChangeListener;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class AbstractPartitionedStorageProviderTest {
    public static final String SOME_METADATA_NAME = "some-metadata-name";
    Condition<TaskChangeListenerForTest> closeCalled = new Condition(x -> x.closeIsCalled, "Close is called", new Object[0]);
    Condition<TaskChangeListenerForTest> taskNotNull = new Condition(x -> x.task != null, "Has Task", new Object[0]);
    private PartitionedStorageProvider storageProvider;

    @BeforeEach
    void setUpStorageProvider() {
        this.storageProvider = (PartitionedStorageProvider)Mockito.spy((Object)new InMemoryPartitionedStorageProvider());
        this.storageProvider.setTaskMapper(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
    }

    @Test
    void taskStatsChangeListenersAreNotifiedOfTaskStats() {
        TaskStatsChangeListenerForTest changeListener = new TaskStatsChangeListenerForTest();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Object)changeListener.taskStatsData).isNotNull());
    }

    @Test
    void backgroundTaskServerStatusChangeListenersAreNotifiedOfBackgroundTaskServers() {
        BackgroundTaskServerStatusChangeListenerForTest changeListener = new BackgroundTaskServerStatusChangeListenerForTest();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat(changeListener.changedServerStates).isNotNull());
    }

    @Test
    void metadataChangeListenersAreNotifiedOfMetadataChanges() {
        CarrotMetadata carrotMetadata = new CarrotMetadata(SOME_METADATA_NAME, "some owner", "some value");
        this.storageProvider.saveMetadata(carrotMetadata);
        MetadataChangeListenerForTest changeListener = new MetadataChangeListenerForTest();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat(changeListener.metadataList).isNotNull());
    }

    @Test
    void TaskChangeListenersAreNotifiedOfTasks() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.storageProvider.save(task);
        TaskChangeListenerForTest changeListener = new TaskChangeListenerForTest(new TaskId(task.getId()));
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Object)changeListener).has(this.taskNotNull));
    }

    @Test
    void ifMultipleTaskChangeListenersForSameTaskStillOneDatabaseCall() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        this.storageProvider.save(task);
        TaskChangeListenerForTest changeListener1 = new TaskChangeListenerForTest(new TaskId(task.getId()));
        TaskChangeListenerForTest changeListener2 = new TaskChangeListenerForTest(new TaskId(task.getId()));
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener1);
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener2);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Object)changeListener1.task).isNotNull());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Object)changeListener2.task).isNotNull());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)1))).getTaskById(task.getId());
    }

    @Test
    void TaskChangeListenersAreClosedIfTaskDoesNotExist() {
        TaskChangeListenerForTest changeListener = new TaskChangeListenerForTest(new TaskId(UUID.randomUUID()));
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Object)changeListener).has(this.closeCalled));
    }

    @Test
    void updatingOnChangeListenersIsThreadSafe() {
        ArrayList<SlowTaskChangeListenerForTest> changeListeners = new ArrayList<SlowTaskChangeListenerForTest>();
        for (int i = 0; i < 10; ++i) {
            SlowTaskChangeListenerForTest changeListener = new SlowTaskChangeListenerForTest();
            this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
            changeListeners.add(changeListener);
        }
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((List)changeListeners).anyMatch(taskStatsChangeListenerForTest -> taskStatsChangeListenerForTest.taskStatsData != null));
        this.storageProvider.removeTaskStorageOnChangeListener((StorageProviderChangeListener)changeListeners.get(9));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((List)changeListeners).allMatch(taskStatsChangeListenerForTest -> taskStatsChangeListenerForTest.taskStatsData != null));
    }

    @Test
    void updateTimerIsStoppedIfNoChangeListeners() {
        TaskStatsChangeListenerForTest changeListener = new TaskStatsChangeListenerForTest();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Timer timerAfterAddingChangeListener = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerAfterAddingChangeListener).isNotNull();
        this.storageProvider.removeTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Timer timerAfterRemovingChangeListener = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerAfterRemovingChangeListener).isNull();
    }

    @Test
    void updateTimerIsStoppedWhenStorageProviderIsStopped() {
        TaskStatsChangeListenerForTest changeListener = new TaskStatsChangeListenerForTest();
        this.storageProvider.addTaskStorageOnChangeListener((StorageProviderChangeListener)changeListener);
        Timer timerAfterAddingChangeListener = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerAfterAddingChangeListener).isNotNull();
        this.storageProvider.close();
        Timer timerAfterClosingStorageProvider = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerAfterClosingStorageProvider).isNull();
    }

    private static class SlowTaskChangeListenerForTest
    extends TaskStatsChangeListenerForTest {
        private SlowTaskChangeListenerForTest() {
        }

        @Override
        public void onChange(TaskStatsData taskStatsData) {
            try {
                Thread.sleep(100L);
                super.onChange(taskStatsData);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TaskChangeListenerForTest
    implements TaskChangeListener {
        private final TaskId taskId;
        private boolean closeIsCalled;
        private Task task;

        public TaskChangeListenerForTest(TaskId taskId) {
            this.taskId = taskId;
            this.closeIsCalled = false;
        }

        public TaskId getTaskId() {
            return this.taskId;
        }

        public void onChange(Task task) {
            this.task = task;
        }

        public void close() {
            this.closeIsCalled = true;
        }
    }

    private static class TaskStatsChangeListenerForTest
    implements TaskStatsChangeListener {
        private TaskStatsData taskStatsData;

        private TaskStatsChangeListenerForTest() {
        }

        public void onChange(TaskStatsData taskStatsData) {
            this.taskStatsData = taskStatsData;
        }
    }

    private static class MetadataChangeListenerForTest
    implements MetadataChangeListener {
        private List<CarrotMetadata> metadataList;

        private MetadataChangeListenerForTest() {
        }

        public String listenForChangesOfMetadataName() {
            return AbstractPartitionedStorageProviderTest.SOME_METADATA_NAME;
        }

        public void onChange(List<CarrotMetadata> metadataList) {
            this.metadataList = metadataList;
        }
    }

    private static class BackgroundTaskServerStatusChangeListenerForTest
    implements BackgroundTaskServerStatusChangeListener {
        private List<BackgroundTaskServerStatus> changedServerStates;

        private BackgroundTaskServerStatusChangeListenerForTest() {
        }

        public void onChange(List<BackgroundTaskServerStatus> changedServerStates) {
            this.changedServerStates = changedServerStates;
        }
    }
}

