/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.fixtures.storage.PartitionedStorageProviderTest;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.StorageException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import cn.boboweike.carrot.utils.resilience.RateLimiter;
import java.util.Map;
import java.util.UUID;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class InMemoryPartitionedStorageProviderTest
extends PartitionedStorageProviderTest {
    private PartitionedStorageProvider storageProvider;

    @Override
    protected void cleanup() {
        this.storageProvider = new InMemoryPartitionedStorageProvider(RateLimiter.Builder.rateLimit().withoutLimits());
        this.storageProvider.setTaskMapper(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
    }

    @Override
    protected PartitionedStorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    @Override
    protected PartitionedStorageProviderTest.ThrowingStorageProvider makeThrowingStorageProvider(PartitionedStorageProvider storageProvider) {
        return new ThrowingInMemoryStorageProvider(storageProvider);
    }

    public class ThrowingInMemoryStorageProvider
    extends PartitionedStorageProviderTest.ThrowingStorageProvider {
        private Map<UUID, Task> originalTaskQueue;

        public ThrowingInMemoryStorageProvider(PartitionedStorageProvider storageProvider) {
            super(storageProvider, "taskQueue");
        }

        @Override
        protected void makeStorageProviderThrowException(PartitionedStorageProvider storageProvider) {
            Map taskQueue = (Map)Mockito.mock(Map.class);
            Mockito.when((Object)taskQueue.put((UUID)Mockito.any(), (Task)Mockito.any())).thenThrow(new Throwable[]{new StorageException("Boem!")});
            Whitebox.setInternalState(storageProvider, "taskQueue", taskQueue);
        }
    }
}

