/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.storage.Page;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PageTest {
    @Test
    void testPaging1() {
        Page page = new Page(50L, new ArrayList(), 15L, 5);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(50L);
        Assertions.assertThat((long)page.getOffset()).isEqualTo(15L);
        Assertions.assertThat((int)page.getLimit()).isEqualTo(5);
        Assertions.assertThat((int)page.getCurrentPage()).isEqualTo(3);
        Assertions.assertThat((int)page.getTotalPages()).isEqualTo(10);
        Assertions.assertThat((boolean)page.hasPrevious()).isTrue();
        Assertions.assertThat((boolean)page.hasNext()).isTrue();
    }

    @Test
    void testPaging2() {
        Page page = new Page(5L, new ArrayList(), 2L, 2);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(5L);
        Assertions.assertThat((long)page.getOffset()).isEqualTo(2L);
        Assertions.assertThat((int)page.getLimit()).isEqualTo(2);
        Assertions.assertThat((int)page.getCurrentPage()).isEqualTo(1);
        Assertions.assertThat((int)page.getTotalPages()).isEqualTo(3);
        Assertions.assertThat((boolean)page.hasPrevious()).isTrue();
        Assertions.assertThat((boolean)page.hasNext()).isTrue();
    }

    @Test
    void testPaging3() {
        Page page = new Page(5L, new ArrayList(), 0L, 20);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(5L);
        Assertions.assertThat((long)page.getOffset()).isZero();
        Assertions.assertThat((int)page.getLimit()).isEqualTo(20);
        Assertions.assertThat((int)page.getCurrentPage()).isZero();
        Assertions.assertThat((int)page.getTotalPages()).isEqualTo(1);
        Assertions.assertThat((boolean)page.hasPrevious()).isFalse();
        Assertions.assertThat((boolean)page.hasNext()).isFalse();
    }

    @Test
    void testPagingStrangeValues1() {
        Page page = new Page(5L, new ArrayList(), 1L, 4);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(5L);
        Assertions.assertThat((long)page.getOffset()).isEqualTo(1L);
        Assertions.assertThat((int)page.getLimit()).isEqualTo(4);
        Assertions.assertThat((int)page.getCurrentPage()).isEqualTo(1);
        Assertions.assertThat((int)page.getTotalPages()).isEqualTo(2);
        Assertions.assertThat((boolean)page.hasPrevious()).isTrue();
        Assertions.assertThat((boolean)page.hasNext()).isFalse();
    }

    @Test
    void testPagingStrangeValues2() {
        Page page = new Page(5L, new ArrayList(), 1L, 3);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(5L);
        Assertions.assertThat((long)page.getOffset()).isEqualTo(1L);
        Assertions.assertThat((int)page.getLimit()).isEqualTo(3);
        Assertions.assertThat((int)page.getCurrentPage()).isEqualTo(1);
        Assertions.assertThat((int)page.getTotalPages()).isEqualTo(2);
        Assertions.assertThat((boolean)page.hasPrevious()).isTrue();
        Assertions.assertThat((boolean)page.hasNext()).isTrue();
    }
}

