/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.fixtures.utils.SleepUtils;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsEnricher;
import cn.boboweike.carrot.storage.TaskStatsExtended;
import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TaskStatsEnricherTest {
    private TaskStatsEnricher taskStatsEnricher;

    @BeforeEach
    void setUpTaskStatsEnricher() {
        this.taskStatsEnricher = new TaskStatsEnricher();
    }

    @Test
    void enrichGivenNoPreviousTaskStatsAndNoWorkToDo() {
        TaskStatsExtended extendedTaskStats = this.taskStatsEnricher.enrich(this.getTaskStats(0L, 0L, 0L, 0L));
        Assertions.assertThat((Long)extendedTaskStats.getAmountSucceeded()).isZero();
        Assertions.assertThat((Long)extendedTaskStats.getAmountFailed()).isZero();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isProcessingDone()).isTrue();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isFalse();
    }

    @Test
    void enrichGivenNoPreviousTaskStatsAndWorkToDoEnqueuedAndProcessing() {
        TaskStatsExtended extendedTaskStats = this.taskStatsEnricher.enrich(this.getTaskStats(1L, 1L, 0L, 0L));
        Assertions.assertThat((Long)extendedTaskStats.getAmountSucceeded()).isZero();
        Assertions.assertThat((Long)extendedTaskStats.getAmountFailed()).isZero();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isFalse();
    }

    @Test
    void enrichGivenNoPreviousTaskStatsAndWorkToDoProcessing() {
        TaskStatsExtended extendedTaskStats = this.taskStatsEnricher.enrich(this.getTaskStats(0L, 1L, 0L, 0L));
        Assertions.assertThat((Long)extendedTaskStats.getAmountSucceeded()).isZero();
        Assertions.assertThat((Long)extendedTaskStats.getAmountFailed()).isZero();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((boolean)extendedTaskStats.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isFalse();
    }

    @Test
    void firstRelevantTaskStatsIsSetInitially() {
        TaskStats firstTaskStats = this.getTaskStats(0L, 0L, 0L, 100L);
        this.taskStatsEnricher.enrich(firstTaskStats);
        TaskStats taskStats = (TaskStats)Whitebox.getInternalState(this.taskStatsEnricher, "firstRelevantTaskStats");
        Assertions.assertThat((Object)taskStats).isEqualToComparingFieldByField((Object)firstTaskStats);
    }

    @Test
    void firstRelevantTaskStatsIsUpdated() {
        TaskStats firstTaskStats = this.getTaskStats(0L, 0L, 0L, 100L);
        TaskStats secondTaskStats = this.getTaskStats(10L, 0L, 0L, 100L);
        this.taskStatsEnricher.enrich(firstTaskStats);
        this.taskStatsEnricher.enrich(secondTaskStats);
        TaskStats taskStats = (TaskStats)Whitebox.getInternalState(this.taskStatsEnricher, "firstRelevantTaskStats");
        Assertions.assertThat((Object)taskStats).isEqualToComparingFieldByField((Object)secondTaskStats);
    }

    @Test
    void firstRelevantTaskStatsIsUpdatedAfterWorkIsDone() {
        TaskStats firstTaskStats = this.getTaskStats(0L, 0L, 0L, 100L);
        this.taskStatsEnricher.enrich(firstTaskStats);
        SleepUtils.sleep(2L);
        TaskStats secondTaskStats = this.getTaskStats(10L, 0L, 0L, 100L);
        this.taskStatsEnricher.enrich(secondTaskStats);
        SleepUtils.sleep(2L);
        TaskStats thirdTaskStats = this.getTaskStats(0L, 0L, 0L, 110L);
        this.taskStatsEnricher.enrich(thirdTaskStats);
        SleepUtils.sleep(2L);
        TaskStats taskStats = (TaskStats)Whitebox.getInternalState(this.taskStatsEnricher, "firstRelevantTaskStats");
        Assertions.assertThat((Object)taskStats).isEqualToComparingFieldByField((Object)thirdTaskStats);
    }

    @Test
    void estimatedTimeProcessingIsCalculated1() {
        TaskStats firstTaskStats = this.getTaskStats(Instant.now().minusSeconds(10L), 100L, 0L, 0L, 100L);
        TaskStats secondTaskStats = this.getTaskStats(Instant.now(), 85L, 5L, 0L, 110L);
        TaskStatsExtended secondTaskStatsExtended = this.enrich(firstTaskStats, secondTaskStats);
        Assertions.assertThat((boolean)secondTaskStatsExtended.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((long)Duration.between(Instant.now(), secondTaskStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()).toSeconds()).isCloseTo(90L, Offset.offset((Number)1L));
    }

    @Test
    void estimatedTimeProcessingIsCalculated2() {
        TaskStats taskStats0 = this.getTaskStats(Instant.now().minusSeconds(60L), 100L, 0L, 0L, 100L);
        TaskStats taskStats1 = this.getTaskStats(Instant.now().minusSeconds(50L), 85L, 5L, 0L, 110L);
        TaskStats taskStats2 = this.getTaskStats(Instant.now().minusSeconds(40L), 75L, 5L, 0L, 120L);
        TaskStats taskStats3 = this.getTaskStats(Instant.now().minusSeconds(30L), 65L, 5L, 0L, 130L);
        TaskStats taskStats4 = this.getTaskStats(Instant.now().minusSeconds(20L), 55L, 5L, 0L, 140L);
        TaskStats taskStats5 = this.getTaskStats(Instant.now().minusSeconds(10L), 45L, 5L, 0L, 150L);
        TaskStats taskStats6 = this.getTaskStats(Instant.now(), 35L, 5L, 0L, 160L);
        TaskStatsExtended taskStatsExtended = this.enrich(taskStats0, taskStats1, taskStats2, taskStats3, taskStats4, taskStats5, taskStats6);
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((long)Duration.between(Instant.now(), taskStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()).toSeconds()).isCloseTo(40L, Offset.offset((Number)1L));
    }

    @Test
    void estimatedTimeProcessingIsCalculated3() {
        TaskStats firstTaskStats = this.getTaskStats(Instant.now().minusMillis(10L), 100L, 0L, 0L, 100L);
        TaskStats secondTaskStats = this.getTaskStats(Instant.now(), 99L, 0L, 0L, 101L);
        TaskStatsExtended taskStatsExtended = this.enrich(firstTaskStats, secondTaskStats);
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isFalse();
    }

    @Test
    void estimatedTimeProcessingIsCalculated4() {
        TaskStats firstTaskStats = this.getTaskStats(Instant.now().minusSeconds(10L), 100L, 0L, 0L, 100L);
        TaskStats secondTaskStats = this.getTaskStats(Instant.now(), 99L, 0L, 0L, 101L);
        TaskStatsExtended taskStatsExtended = this.enrich(firstTaskStats, secondTaskStats);
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isTrue();
        Assertions.assertThat((long)Duration.between(Instant.now(), taskStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()).toSeconds()).isCloseTo(990L, Offset.offset((Number)10L));
    }

    @Test
    void estimatedTimeProcessingIsCalculated5() {
        TaskStats firstTaskStats = this.getTaskStats(Instant.now().minusSeconds(3610L), 10L, 0L, 0L, 100L);
        TaskStats secondTaskStats = this.getTaskStats(Instant.now().minusSeconds(3600L), 5L, 4L, 0L, 101L);
        TaskStats thirdTaskStats = this.getTaskStats(Instant.now(), 4L, 4L, 0L, 102L);
        TaskStatsExtended taskStatsExtended = this.enrich(firstTaskStats, secondTaskStats, thirdTaskStats);
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isProcessingDone()).isFalse();
        Assertions.assertThat((boolean)taskStatsExtended.getEstimation().isEstimatedProcessingFinishedInstantAvailable()).isTrue();
        Assertions.assertThat((long)Duration.between(Instant.now(), taskStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()).toSeconds()).isCloseTo(80L, Offset.offset((Number)2L));
    }

    private TaskStatsExtended enrich(TaskStats ... allTaskStats) {
        TaskStatsExtended lastTaskStatsExtends = null;
        for (TaskStats taskStats : allTaskStats) {
            lastTaskStatsExtends = this.taskStatsEnricher.enrich(taskStats);
        }
        return lastTaskStatsExtends;
    }

    private TaskStats getTaskStats(long enqueued, long processing, long failed, long succeeded) {
        return this.getTaskStats(Instant.now(), enqueued, processing, failed, succeeded);
    }

    private TaskStats getTaskStats(Instant instant, long enqueued, long processing, long failed, long succeeded) {
        return new TaskStats(instant, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(enqueued), Long.valueOf(processing), Long.valueOf(failed), Long.valueOf(succeeded), Long.valueOf(0L), Long.valueOf(0L), 1, 1);
    }
}

