/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.ThreadSafePartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ThreadSafeStorageProviderTest {
    @Mock
    private PartitionedStorageProvider storageProviderMock;
    private ThreadSafePartitionedStorageProvider threadSafeStorageProvider;

    @BeforeEach
    void setUp() {
        this.threadSafeStorageProvider = new ThreadSafePartitionedStorageProvider(this.storageProviderMock);
        Mockito.lenient().when((Object)this.storageProviderMock.save((Task)ArgumentMatchers.any(Task.class))).thenAnswer(invocation -> {
            Thread.sleep(100L);
            return invocation.getArgument(0);
        });
        Mockito.lenient().when((Object)this.storageProviderMock.save((List)ArgumentMatchers.any(List.class))).thenAnswer(invocation -> {
            Thread.sleep(100L);
            return invocation.getArgument(0);
        });
    }

    @Test
    void multipleTasksCanBeSavedConcurrently() throws InterruptedException {
        Task succeededTask1 = TaskTestBuilder.aSucceededTask().build();
        Task succeededTask2 = TaskTestBuilder.aSucceededTask().build();
        Task succeededTask3 = TaskTestBuilder.aSucceededTask().build();
        Task failedTask = TaskTestBuilder.aFailedTask().build();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        Callable<Void> runnable1 = () -> this.saveAndCountDown(succeededTask1, countDownLatch);
        Callable<Void> runnable2 = () -> this.saveAndCountDown(succeededTask2, countDownLatch);
        Callable<Void> runnable3 = () -> this.saveAndCountDown(succeededTask3, countDownLatch);
        Callable<Void> runnable4 = () -> this.saveAndCountDown(failedTask, countDownLatch);
        Instant before = Instant.now();
        executorService.invokeAll(Arrays.asList(runnable1, runnable2, runnable3, runnable4));
        countDownLatch.await();
        Instant after = Instant.now();
        Assertions.assertThat((long)Duration.between(before, after).toMillis()).isLessThan(250L);
    }

    @Test
    void sameTaskCanNotBeSavedConcurrently() throws InterruptedException {
        Task taskInProgress1 = TaskTestBuilder.aTaskInProgress().build();
        Task taskInProgress2 = TaskTestBuilder.aTaskInProgress().build();
        Task finishedTask = TaskTestBuilder.aCopyOf(taskInProgress1).withSucceededState().build();
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Callable<Void> runnable1 = () -> this.saveAllAndCountDown(Arrays.asList(taskInProgress1, taskInProgress2), countDownLatch);
        Callable<Void> runnable2 = () -> this.saveAndCountDown(finishedTask, countDownLatch);
        Instant before = Instant.now();
        executorService.invokeAll(Arrays.asList(runnable1, runnable2));
        countDownLatch.await();
        Instant after = Instant.now();
        Assertions.assertThat((long)Duration.between(before, after).toMillis()).isGreaterThan(200L);
    }

    private Void saveAndCountDown(Task task, CountDownLatch countDownLatch) {
        this.threadSafeStorageProvider.save(task);
        countDownLatch.countDown();
        return null;
    }

    private Void saveAllAndCountDown(List<Task> tasks, CountDownLatch countDownLatch) {
        this.threadSafeStorageProvider.save(tasks);
        countDownLatch.countDown();
        return null;
    }
}

