/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo;

import cn.boboweike.carrot.fixtures.storage.PartitionedStorageProviderTest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.nosql.mongo.MongoDBPartitionedStorageProvider;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import cn.boboweike.carrot.utils.resilience.RateLimiter;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterAll;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.testcontainers.containers.GenericContainer;

public abstract class AbstractMongoDBPartitionedStorageProviderTest
extends PartitionedStorageProviderTest {
    private static MongoClient mongoClient;

    protected abstract GenericContainer getMongoContainer();

    @Override
    protected void cleanup() {
        this.cleanup("carrot");
    }

    protected void cleanup(String dbName) {
        MongoDatabase carrotDb = this.mongoClient().getDatabase(dbName);
        ((ArrayList)carrotDb.listCollectionNames().into(new ArrayList())).stream().filter(collectionName -> !collectionName.equals("migrations")).forEach(collectionName -> carrotDb.getCollection(collectionName).deleteMany((Bson)new Document()));
    }

    @Override
    protected PartitionedStorageProvider getStorageProvider() {
        MongoDBPartitionedStorageProvider dbStorageProvider = new MongoDBPartitionedStorageProvider(this.mongoClient(), RateLimiter.Builder.rateLimit().withoutLimits(), 1);
        dbStorageProvider.setTaskMapper(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
        return dbStorageProvider;
    }

    @Override
    protected PartitionedStorageProviderTest.ThrowingStorageProvider makeThrowingStorageProvider(PartitionedStorageProvider storageProvider) {
        return new ThrowingMongoDBStorageProvider(storageProvider);
    }

    @AfterAll
    public static void closeMongoClient() {
        mongoClient.close();
        mongoClient = null;
    }

    protected MongoClient mongoClient() {
        GenericContainer mongoContainer = this.getMongoContainer();
        if (mongoClient == null) {
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()});
            mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Arrays.asList(new ServerAddress(mongoContainer.getContainerIpAddress(), mongoContainer.getMappedPort(27017).intValue())))).codecRegistry(codecRegistry).build());
        }
        return mongoClient;
    }

    protected static class ThrowingMongoDBStorageProvider
    extends PartitionedStorageProviderTest.ThrowingStorageProvider {
        public ThrowingMongoDBStorageProvider(PartitionedStorageProvider storageProvider) {
            super(storageProvider, "taskCollectionMap");
        }

        @Override
        protected void makeStorageProviderThrowException(PartitionedStorageProvider storageProvider) {
            MongoCollection mockedTaskCollection = (MongoCollection)Mockito.mock(MongoCollection.class);
            HashMap<Integer, MongoCollection> map = new HashMap<Integer, MongoCollection>();
            map.put(PartitionedStorageProviderTest.PARTITION_0, mockedTaskCollection);
            MongoException mongoException = (MongoException)Mockito.mock(MongoException.class);
            Mockito.when((Object)mockedTaskCollection.updateOne((Bson)ArgumentMatchers.any(), (Bson)ArgumentMatchers.any())).thenThrow(new Throwable[]{mongoException});
            Mockito.when((Object)mockedTaskCollection.bulkWrite((List)ArgumentMatchers.any())).thenThrow(new Throwable[]{mongoException});
            Whitebox.setInternalState(storageProvider, "taskCollectionMap", map);
        }
    }
}

