/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.storage.nosql.mongo.MongoDBCreator;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M001_CreateTaskCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M002_CreateRecurringTaskCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.MongoMigration;
import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@ExtendWith(value={MockitoExtension.class})
public class MongoDBCreatorTest {
    @Container
    private static final GenericContainer mongoContainer = new GenericContainer("mongo:3.4").withExposedPorts(new Integer[]{27017});
    private static int NUMBER_OF_PARTITIONS = 9;

    @BeforeEach
    void clearAllCollections() {
        MongoDatabase database = this.mongoClient().getDatabase("carrot");
        ArrayList collectionNames = (ArrayList)database.listCollectionNames().into(new ArrayList());
        collectionNames.forEach(collectionName -> database.getCollection(collectionName).drop());
    }

    @Test
    void testMigrationHappyPath() {
        MongoDBCreator mongoDBCreator = new MongoDBCreator(this.mongoClient(), "carrot", NUMBER_OF_PARTITIONS);
        Assertions.assertThat((boolean)mongoDBCreator.isNewMigration((MongoMigration)new M001_CreateTaskCollection())).isTrue();
        Assertions.assertThat((boolean)mongoDBCreator.isNewMigration((MongoMigration)new M002_CreateRecurringTaskCollection())).isTrue();
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        Assertions.assertThat((boolean)mongoDBCreator.isNewMigration((MongoMigration)new M001_CreateTaskCollection())).isFalse();
        Assertions.assertThat((boolean)mongoDBCreator.isNewMigration((MongoMigration)new M002_CreateRecurringTaskCollection())).isFalse();
    }

    @Test
    void testValidateCollectionsNoCollectionPrefix() {
        MongoDBCreator mongoDBCreator = new MongoDBCreator(this.mongoClient(), "carrot", NUMBER_OF_PARTITIONS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MongoDBCreator)mongoDBCreator).validateCollections()).isInstanceOf(CarrotException.class)).hasMessage("Not all required collections are available by Carrot!");
        mongoDBCreator.runMigrations();
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).validateCollections()).doesNotThrowAnyException();
        Assertions.assertThat((List)((List)this.mongoClient().getDatabase("carrot").listCollectionNames().into(new ArrayList()))).hasSize(22);
    }

    @Test
    void testValidateCollectionsWithCollectionPrefix() {
        MongoDBCreator mongoDBCreator = new MongoDBCreator(this.mongoClient(), "carrot", "MYCOLLECTIONPREFIX_", NUMBER_OF_PARTITIONS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MongoDBCreator)mongoDBCreator).validateCollections()).isInstanceOf(CarrotException.class)).hasMessage("Not all required collections are available by Carrot!");
        mongoDBCreator.runMigrations();
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).validateCollections()).doesNotThrowAnyException();
        Assertions.assertThat((List)((List)this.mongoClient().getDatabase("carrot").listCollectionNames().into(new ArrayList()))).hasSize(22);
    }

    @Test
    void testMigrationConcurrent() {
        MongoDBCreator mongoDBCreator = new MongoDBCreator(this.mongoClient(), "carrot", NUMBER_OF_PARTITIONS){

            protected boolean isNewMigration(MongoMigration mongoMigration) {
                return true;
            }
        };
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
    }

    @Test
    void testIncreasePartitions() {
        MongoClient mongoClient = this.mongoClient();
        MongoDBCreator mongoDBCreator = new MongoDBCreator(mongoClient, "carrot", NUMBER_OF_PARTITIONS);
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        mongoDBCreator = new MongoDBCreator(mongoClient, "carrot", NUMBER_OF_PARTITIONS + 1);
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        mongoDBCreator = new MongoDBCreator(mongoClient, "carrot", NUMBER_OF_PARTITIONS + 9);
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
    }

    @Test
    void testDecreasePartitions() {
        MongoClient mongoClient = this.mongoClient();
        MongoDBCreator mongoDBCreator = new MongoDBCreator(mongoClient, "carrot", NUMBER_OF_PARTITIONS);
        Assertions.assertThatCode(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).doesNotThrowAnyException();
        mongoDBCreator = new MongoDBCreator(mongoClient, "carrot", NUMBER_OF_PARTITIONS - 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MongoDBCreator)mongoDBCreator).runMigrations()).isInstanceOf(CarrotException.class)).hasMessageContaining("Carrot does not support decreasing the number of partitions");
    }

    private MongoClient mongoClient() {
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()});
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Arrays.asList(new ServerAddress(mongoContainer.getContainerIpAddress(), mongoContainer.getMappedPort(27017).intValue())))).codecRegistry(codecRegistry).build());
    }
}

