/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.utils.resilience.Lock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class AbstractTaskTest {
    @Test
    void increaseVersion() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Assertions.assertThat((int)task.getVersion()).isZero();
        Assertions.assertThat((int)task.increaseVersion()).isEqualTo(1);
        Assertions.assertThat((int)task.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)task.increaseVersion()).isEqualTo(2);
        Assertions.assertThat((int)task.getVersion()).isEqualTo(2);
    }

    @Test
    void whileLockedTaskCannotBeLockedForOtherSaveAction() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        Lock lock = task.lock();
        Awaitility.await().during(1L, TimeUnit.SECONDS).atMost(2L, TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            new Thread(() -> {
                task.lock();
                atomicBoolean.set(true);
            }).start();
            Assertions.assertThat((boolean)lock.isLocked()).isTrue();
            Assertions.assertThat((AtomicBoolean)atomicBoolean).isFalse();
        });
    }
}

