/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecurringTaskTest {
    @Test
    void onlyValidIdsAreAllowed() {
        Assertions.assertThatCode(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withoutId().build()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withId("this-is-allowed-with-a-1").build()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withId("this_is_ALSO_allowed_with_a_2").build()).doesNotThrowAnyException();
        Assertions.assertThatThrownBy(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withId("this is not allowed").build()).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withId("this-is-also-not-allowed-because-of-$").build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void ifNoIdGivenItUsesTaskSignature() {
        TestService testService = new TestService();
        RecurringTask recurringTask1 = RecurringTaskTestBuilder.aDefaultRecurringTask().withoutId().withTaskDetails((TaskLambda & Serializable)() -> System.out.println("This is a test")).build();
        CarrotAssertions.assertThat((String)recurringTask1.getId()).isEqualTo("java.lang.System.out.println(java.lang.String)");
        IocTaskLambda & Serializable iocTaskLambda = (IocTaskLambda & Serializable)x -> x.doWork(3, 97693);
        RecurringTask recurringTask2 = RecurringTaskTestBuilder.aDefaultRecurringTask().withoutId().withTaskDetails(iocTaskLambda).build();
        CarrotAssertions.assertThat((String)recurringTask2.getId()).isEqualTo("cn.boboweike.carrot.fixtures.stubs.TestService.doWork(java.lang.Integer,java.lang.Integer)");
        RecurringTask recurringTask3 = RecurringTaskTestBuilder.aDefaultRecurringTask().withoutId().withTaskDetails(testService::doWork).build();
        CarrotAssertions.assertThat((String)recurringTask3.getId()).isEqualTo("cn.boboweike.carrot.fixtures.stubs.TestService.doWork()");
    }

    @Test
    void testToScheduledTask() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withId("the-recurring-task").withName("the recurring task").build();
        Task task = recurringTask.toScheduledTask();
        CarrotAssertions.assertThat(task).hasRecurringTaskId("the-recurring-task").hasTaskName("the recurring task");
    }

    @Test
    void testToEnqueuedTask() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withId("the-recurring-task").withName("the recurring task").build();
        Task task = recurringTask.toEnqueuedTask();
        CarrotAssertions.assertThat(task).hasRecurringTaskId("the-recurring-task").hasTaskName("the recurring task");
    }

    @Test
    void nextInstantWithCronExpressionIsCorrect() {
        LocalDateTime localDateTime = LocalDateTime.now();
        LocalDateTime timeForCron = localDateTime.plusMinutes(-1L);
        int hour = timeForCron.getHour();
        int minute = timeForCron.getMinute();
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withName("the recurring task").withCronExpression(Cron.daily((int)hour, (int)minute)).withZoneId(ZoneOffset.of("+02:00")).build();
        Instant nextRun = recurringTask.getNextRun();
        CarrotAssertions.assertThat((Instant)nextRun).isAfter(Instant.now());
    }

    @Test
    void nextInstantWithIntervalIsCorrect() {
        RecurringTask recurringTask = RecurringTaskTestBuilder.aDefaultRecurringTask().withName("the recurring task").withIntervalExpression(Duration.ofHours(1L).toString()).withZoneId(ZoneOffset.of("+02:00")).build();
        Instant nextRun = recurringTask.getNextRun();
        CarrotAssertions.assertThat((Instant)nextRun).isAfter(Instant.now());
    }

    @Test
    void smallestIntervalForRecurringCronTaskIs5Seconds() {
        Assertions.assertThatThrownBy(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withCronExpression("* * * * * *").build()).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatCode(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withCronExpression("*/5 * * * * *").build()).doesNotThrowAnyException();
    }

    @Test
    void smallestIntervalForRecurringIntervalTaskIs5Seconds() {
        Assertions.assertThatThrownBy(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withIntervalExpression(Duration.ofSeconds(4L).toString()).build()).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatCode(() -> RecurringTaskTestBuilder.aDefaultRecurringTask().withIntervalExpression(Duration.ofSeconds(5L).toString()).build()).doesNotThrowAnyException();
    }
}

