/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.stubs.TestService;
import cn.boboweike.carrot.fixtures.stubs.TestTaskRequest;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import java.util.Collections;
import org.junit.jupiter.api.Test;

public class TaskDetailsTest {
    @Test
    void testTaskDetailsDefaultConstructor() {
        TaskDetails taskDetails = new TaskDetails("some.class.Name", null, "run", Collections.emptyList());
        CarrotAssertions.assertThat(taskDetails).isNotCacheable();
    }

    @Test
    void testTaskDetails() {
        TaskDetails taskDetails = TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").withTaskParameter(5).build();
        CarrotAssertions.assertThat(taskDetails).hasClass(TestService.class).hasStaticFieldName(null).hasMethodName("doWork").hasArgs(5).isNotCacheable();
        CarrotAssertions.assertThat((Object[])taskDetails.getTaskParameterTypes()).isEqualTo((Object)new Class[]{Integer.class});
        CarrotAssertions.assertThat((Object[])taskDetails.getTaskParameterValues()).isEqualTo((Object)new Object[]{5});
    }

    @Test
    void testTaskDetailsWithoutParameters() {
        TaskDetails taskDetails = TaskDetailsTestBuilder.taskDetails().withClassName(TestService.class).withMethodName("doWork").build();
        CarrotAssertions.assertThat(taskDetails).hasClass(TestService.class).hasStaticFieldName(null).hasMethodName("doWork").hasNoArgs().isNotCacheable();
        CarrotAssertions.assertThat((Object[])taskDetails.getTaskParameterTypes()).isEqualTo((Object)new Class[0]);
        CarrotAssertions.assertThat((Object[])taskDetails.getTaskParameterValues()).isEqualTo((Object)new Object[0]);
    }

    @Test
    void testTaskDetailsFromTaskRequest() {
        TestTaskRequest taskRequest = new TestTaskRequest("some input");
        TaskDetails taskDetails = new TaskDetails((TaskRequest)taskRequest);
        CarrotAssertions.assertThat(taskDetails).hasClass(TestTaskRequest.TestTaskRequestHandler.class).hasStaticFieldName(null).hasMethodName("run").hasArgs(taskRequest).isCacheable();
    }
}

