/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.EnqueuedState;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.SucceededState;
import cn.boboweike.carrot.tasks.states.TaskState;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TaskTest {
    @Mock
    private BackgroundTaskServer backgroundTaskServer;

    @Test
    void ifIdIsNullAnIdIsCreated() {
        Task taskWithoutIdProvided = new Task(TaskDetailsTestBuilder.taskDetails().build());
        CarrotAssertions.assertThat((Comparable)taskWithoutIdProvided.getId()).isNotNull();
        Task taskWithNullIdProvided = new Task(null, TaskDetailsTestBuilder.taskDetails().build());
        CarrotAssertions.assertThat((Comparable)taskWithNullIdProvided.getId()).isNotNull();
    }

    @Test
    void getTaskSignature() {
        Task task = TaskTestBuilder.anEnqueuedTask().withTaskDetails(TaskDetailsTestBuilder.systemOutPrintLnTaskDetails("some message")).build();
        CarrotAssertions.assertThat((String)task.getTaskSignature()).isEqualTo("java.lang.System.out.println(java.lang.String)");
    }

    @Test
    void taskCannotGoToProcessingTwice() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        task.startProcessingOn(this.backgroundTaskServer);
        Assertions.assertThatThrownBy(() -> task.startProcessingOn(this.backgroundTaskServer)).isInstanceOf(ConcurrentTaskModificationException.class);
    }

    @Test
    void updateProcessingOnlyHasEffectIfTaskIsInProcessingState() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        task.startProcessingOn(this.backgroundTaskServer);
        task.updateProcessing();
        ProcessingState processingState = (ProcessingState)task.getTaskState();
        CarrotAssertions.assertThat((Instant)processingState.getUpdatedAt()).isAfter(processingState.getCreatedAt());
    }

    @Test
    void updateProcessingThrowsExceptionIfTaskHasScheduledState() {
        Task task = TaskTestBuilder.aScheduledTask().build();
        Assertions.assertThatThrownBy(() -> ((Task)task).updateProcessing()).isInstanceOf(ClassCastException.class);
    }

    @Test
    void updateProcessingThrowsExceptionIfTaskHasSucceededState() {
        Task task = TaskTestBuilder.aSucceededTask().build();
        Assertions.assertThatThrownBy(() -> ((Task)task).updateProcessing()).isInstanceOf(ClassCastException.class);
    }

    @Test
    void succeededLatencyOnlyTakesIntoAccountStateFromEnqueuedToProcessing() {
        Task task = TaskTestBuilder.aTask().withState((TaskState)new ScheduledState(Instant.now()), Instant.now().minusSeconds(600L)).withState((TaskState)new EnqueuedState(), Instant.now().minusSeconds(60L)).withState((TaskState)new ProcessingState(this.backgroundTaskServer.getId()), Instant.now().minusSeconds(10L)).build();
        task.updateProcessing();
        task.succeeded();
        SucceededState succeededState = (SucceededState)task.getTaskState();
        CarrotAssertions.assertThat((long)succeededState.getLatencyDuration().toSeconds()).isCloseTo(50L, Offset.offset((Number)1L));
        CarrotAssertions.assertThat((long)succeededState.getProcessDuration().toSeconds()).isCloseTo(10L, Offset.offset((Number)1L));
    }

    @Test
    void metadataIsClearedWhenATaskSucceeds() {
        Task task = TaskTestBuilder.aTaskInProgress().withMetadata("key", "value").build();
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.failed("En exception occured", (Exception)new RuntimeException("boem"));
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.scheduleAt(Instant.now(), "failure before");
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.succeeded();
        CarrotAssertions.assertThat(task).hasNoMetadata();
    }

    @Test
    void metadataIsClearedWhenATaskIsDeleted() {
        Task task = TaskTestBuilder.aTaskInProgress().withMetadata("key", "value").build();
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.failed("En exception occured", (Exception)new RuntimeException("boem"));
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.scheduleAt(Instant.now(), "failure before");
        CarrotAssertions.assertThat(task).hasMetadata("key", "value");
        task.delete("From UI");
        CarrotAssertions.assertThat(task).hasNoMetadata();
    }
}

